/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.ElasticsearchDestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.CloudWatchLoggingOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchBufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchRetryOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessingConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationDescriptionJsonMarshaller;

public class ElasticsearchDestinationDescriptionJsonMarshaller {
    private static ElasticsearchDestinationDescriptionJsonMarshaller instance;

    public void marshall(ElasticsearchDestinationDescription elasticsearchDestinationDescription, StructuredJsonGenerator jsonGenerator) {
        if (elasticsearchDestinationDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (elasticsearchDestinationDescription.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(elasticsearchDestinationDescription.getRoleARN());
            }
            if (elasticsearchDestinationDescription.getDomainARN() != null) {
                jsonGenerator.writeFieldName("DomainARN").writeValue(elasticsearchDestinationDescription.getDomainARN());
            }
            if (elasticsearchDestinationDescription.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(elasticsearchDestinationDescription.getIndexName());
            }
            if (elasticsearchDestinationDescription.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(elasticsearchDestinationDescription.getTypeName());
            }
            if (elasticsearchDestinationDescription.getIndexRotationPeriod() != null) {
                jsonGenerator.writeFieldName("IndexRotationPeriod").writeValue(elasticsearchDestinationDescription.getIndexRotationPeriod());
            }
            if (elasticsearchDestinationDescription.getBufferingHints() != null) {
                jsonGenerator.writeFieldName("BufferingHints");
                ElasticsearchBufferingHintsJsonMarshaller.getInstance().marshall(elasticsearchDestinationDescription.getBufferingHints(), jsonGenerator);
            }
            if (elasticsearchDestinationDescription.getRetryOptions() != null) {
                jsonGenerator.writeFieldName("RetryOptions");
                ElasticsearchRetryOptionsJsonMarshaller.getInstance().marshall(elasticsearchDestinationDescription.getRetryOptions(), jsonGenerator);
            }
            if (elasticsearchDestinationDescription.getS3BackupMode() != null) {
                jsonGenerator.writeFieldName("S3BackupMode").writeValue(elasticsearchDestinationDescription.getS3BackupMode());
            }
            if (elasticsearchDestinationDescription.getS3DestinationDescription() != null) {
                jsonGenerator.writeFieldName("S3DestinationDescription");
                S3DestinationDescriptionJsonMarshaller.getInstance().marshall(elasticsearchDestinationDescription.getS3DestinationDescription(), jsonGenerator);
            }
            if (elasticsearchDestinationDescription.getProcessingConfiguration() != null) {
                jsonGenerator.writeFieldName("ProcessingConfiguration");
                ProcessingConfigurationJsonMarshaller.getInstance().marshall(elasticsearchDestinationDescription.getProcessingConfiguration(), jsonGenerator);
            }
            if (elasticsearchDestinationDescription.getCloudWatchLoggingOptions() != null) {
                jsonGenerator.writeFieldName("CloudWatchLoggingOptions");
                CloudWatchLoggingOptionsJsonMarshaller.getInstance().marshall(elasticsearchDestinationDescription.getCloudWatchLoggingOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticsearchDestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticsearchDestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

