/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.PutAutoScalingPolicyRequest;
import com.amazonaws.services.elasticmapreduce.model.transform.AutoScalingPolicyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutAutoScalingPolicyRequestMarshaller
implements Marshaller<Request<PutAutoScalingPolicyRequest>, PutAutoScalingPolicyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutAutoScalingPolicyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutAutoScalingPolicyRequest> marshall(PutAutoScalingPolicyRequest putAutoScalingPolicyRequest) {
        if (putAutoScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putAutoScalingPolicyRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.PutAutoScalingPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putAutoScalingPolicyRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(putAutoScalingPolicyRequest.getClusterId());
            }
            if (putAutoScalingPolicyRequest.getInstanceGroupId() != null) {
                jsonGenerator.writeFieldName("InstanceGroupId").writeValue(putAutoScalingPolicyRequest.getInstanceGroupId());
            }
            if (putAutoScalingPolicyRequest.getAutoScalingPolicy() != null) {
                jsonGenerator.writeFieldName("AutoScalingPolicy");
                AutoScalingPolicyJsonMarshaller.getInstance().marshall(putAutoScalingPolicyRequest.getAutoScalingPolicy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

