/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.certificatemanager.model.CertificateStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCertificatesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> certificateStatuses;
    private String nextToken;
    private Integer maxItems;

    public List<String> getCertificateStatuses() {
        return this.certificateStatuses;
    }

    public void setCertificateStatuses(Collection<String> certificateStatuses) {
        if (certificateStatuses == null) {
            this.certificateStatuses = null;
            return;
        }
        this.certificateStatuses = new ArrayList<String>(certificateStatuses);
    }

    public ListCertificatesRequest withCertificateStatuses(String ... certificateStatuses) {
        if (this.certificateStatuses == null) {
            this.setCertificateStatuses(new ArrayList<String>(certificateStatuses.length));
        }
        for (String ele : certificateStatuses) {
            this.certificateStatuses.add(ele);
        }
        return this;
    }

    public ListCertificatesRequest withCertificateStatuses(Collection<String> certificateStatuses) {
        this.setCertificateStatuses(certificateStatuses);
        return this;
    }

    public ListCertificatesRequest withCertificateStatuses(CertificateStatus ... certificateStatuses) {
        ArrayList<String> certificateStatusesCopy = new ArrayList<String>(certificateStatuses.length);
        for (CertificateStatus value : certificateStatuses) {
            certificateStatusesCopy.add(value.toString());
        }
        if (this.getCertificateStatuses() == null) {
            this.setCertificateStatuses(certificateStatusesCopy);
        } else {
            this.getCertificateStatuses().addAll(certificateStatusesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCertificatesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ListCertificatesRequest withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateStatuses() != null) {
            sb.append("CertificateStatuses: ").append(this.getCertificateStatuses()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)obj;
        if (other.getCertificateStatuses() == null ^ this.getCertificateStatuses() == null) {
            return false;
        }
        if (other.getCertificateStatuses() != null && !other.getCertificateStatuses().equals(this.getCertificateStatuses())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateStatuses() == null ? 0 : this.getCertificateStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public ListCertificatesRequest clone() {
        return (ListCertificatesRequest)super.clone();
    }
}

