/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.TraceSummary;
import com.amazonaws.services.xray.model.TraceUser;
import com.amazonaws.services.xray.model.ValueWithServiceIds;
import com.amazonaws.services.xray.model.transform.HttpJsonMarshaller;
import com.amazonaws.services.xray.model.transform.ServiceIdJsonMarshaller;
import com.amazonaws.services.xray.model.transform.TraceUserJsonMarshaller;
import com.amazonaws.services.xray.model.transform.ValueWithServiceIdsJsonMarshaller;
import java.util.List;
import java.util.Map;

public class TraceSummaryJsonMarshaller {
    private static TraceSummaryJsonMarshaller instance;

    public void marshall(TraceSummary traceSummary, StructuredJsonGenerator jsonGenerator) {
        if (traceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ServiceId> serviceIdsList;
            List<TraceUser> usersList;
            Map<String, List<ValueWithServiceIds>> annotationsMap;
            jsonGenerator.writeStartObject();
            if (traceSummary.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(traceSummary.getId());
            }
            if (traceSummary.getDuration() != null) {
                jsonGenerator.writeFieldName("Duration").writeValue(traceSummary.getDuration().doubleValue());
            }
            if (traceSummary.getResponseTime() != null) {
                jsonGenerator.writeFieldName("ResponseTime").writeValue(traceSummary.getResponseTime().doubleValue());
            }
            if (traceSummary.getHasFault() != null) {
                jsonGenerator.writeFieldName("HasFault").writeValue(traceSummary.getHasFault().booleanValue());
            }
            if (traceSummary.getHasError() != null) {
                jsonGenerator.writeFieldName("HasError").writeValue(traceSummary.getHasError().booleanValue());
            }
            if (traceSummary.getHasThrottle() != null) {
                jsonGenerator.writeFieldName("HasThrottle").writeValue(traceSummary.getHasThrottle().booleanValue());
            }
            if (traceSummary.getIsPartial() != null) {
                jsonGenerator.writeFieldName("IsPartial").writeValue(traceSummary.getIsPartial().booleanValue());
            }
            if (traceSummary.getHttp() != null) {
                jsonGenerator.writeFieldName("Http");
                HttpJsonMarshaller.getInstance().marshall(traceSummary.getHttp(), jsonGenerator);
            }
            if ((annotationsMap = traceSummary.getAnnotations()) != null) {
                jsonGenerator.writeFieldName("Annotations");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<ValueWithServiceIds>> annotationsMapValue : annotationsMap.entrySet()) {
                    if (annotationsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)annotationsMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (ValueWithServiceIds annotationsMapValueList : (List)annotationsMapValue.getValue()) {
                        if (annotationsMapValueList == null) continue;
                        ValueWithServiceIdsJsonMarshaller.getInstance().marshall(annotationsMapValueList, jsonGenerator);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if ((usersList = traceSummary.getUsers()) != null) {
                jsonGenerator.writeFieldName("Users");
                jsonGenerator.writeStartArray();
                for (TraceUser usersListValue : usersList) {
                    if (usersListValue == null) continue;
                    TraceUserJsonMarshaller.getInstance().marshall(usersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((serviceIdsList = traceSummary.getServiceIds()) != null) {
                jsonGenerator.writeFieldName("ServiceIds");
                jsonGenerator.writeStartArray();
                for (ServiceId serviceIdsListValue : serviceIdsList) {
                    if (serviceIdsListValue == null) continue;
                    ServiceIdJsonMarshaller.getInstance().marshall(serviceIdsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TraceSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TraceSummaryJsonMarshaller();
        }
        return instance;
    }
}

