/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.TraceUser;
import com.amazonaws.services.xray.model.transform.ServiceIdJsonMarshaller;
import java.util.List;

public class TraceUserJsonMarshaller {
    private static TraceUserJsonMarshaller instance;

    public void marshall(TraceUser traceUser, StructuredJsonGenerator jsonGenerator) {
        if (traceUser == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ServiceId> serviceIdsList;
            jsonGenerator.writeStartObject();
            if (traceUser.getUserName() != null) {
                jsonGenerator.writeFieldName("UserName").writeValue(traceUser.getUserName());
            }
            if ((serviceIdsList = traceUser.getServiceIds()) != null) {
                jsonGenerator.writeFieldName("ServiceIds");
                jsonGenerator.writeStartArray();
                for (ServiceId serviceIdsListValue : serviceIdsList) {
                    if (serviceIdsListValue == null) continue;
                    ServiceIdJsonMarshaller.getInstance().marshall(serviceIdsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TraceUserJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TraceUserJsonMarshaller();
        }
        return instance;
    }
}

