/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.RecordingGroup;

public class RecordingGroupJsonMarshaller {
    private static RecordingGroupJsonMarshaller instance;

    public void marshall(RecordingGroup recordingGroup, StructuredJsonGenerator jsonGenerator) {
        if (recordingGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList resourceTypesList;
            jsonGenerator.writeStartObject();
            if (recordingGroup.getAllSupported() != null) {
                jsonGenerator.writeFieldName("allSupported").writeValue(recordingGroup.getAllSupported().booleanValue());
            }
            if (recordingGroup.getIncludeGlobalResourceTypes() != null) {
                jsonGenerator.writeFieldName("includeGlobalResourceTypes").writeValue(recordingGroup.getIncludeGlobalResourceTypes().booleanValue());
            }
            if (!(resourceTypesList = (SdkInternalList)recordingGroup.getResourceTypes()).isEmpty() || !resourceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("resourceTypes");
                jsonGenerator.writeStartArray();
                for (String resourceTypesListValue : resourceTypesList) {
                    if (resourceTypesListValue == null) continue;
                    jsonGenerator.writeValue(resourceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordingGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordingGroupJsonMarshaller();
        }
        return instance;
    }
}

