/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.AttackSummary;
import com.amazonaws.services.shield.model.AttackVectorDescription;
import com.amazonaws.services.shield.model.transform.AttackVectorDescriptionJsonMarshaller;
import java.util.List;

public class AttackSummaryJsonMarshaller {
    private static AttackSummaryJsonMarshaller instance;

    public void marshall(AttackSummary attackSummary, StructuredJsonGenerator jsonGenerator) {
        if (attackSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttackVectorDescription> attackVectorsList;
            jsonGenerator.writeStartObject();
            if (attackSummary.getAttackId() != null) {
                jsonGenerator.writeFieldName("AttackId").writeValue(attackSummary.getAttackId());
            }
            if (attackSummary.getResourceArn() != null) {
                jsonGenerator.writeFieldName("ResourceArn").writeValue(attackSummary.getResourceArn());
            }
            if (attackSummary.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(attackSummary.getStartTime());
            }
            if (attackSummary.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(attackSummary.getEndTime());
            }
            if ((attackVectorsList = attackSummary.getAttackVectors()) != null) {
                jsonGenerator.writeFieldName("AttackVectors");
                jsonGenerator.writeStartArray();
                for (AttackVectorDescription attackVectorsListValue : attackVectorsList) {
                    if (attackVectorsListValue == null) continue;
                    AttackVectorDescriptionJsonMarshaller.getInstance().marshall(attackVectorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttackSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttackSummaryJsonMarshaller();
        }
        return instance;
    }
}

