/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.SummarizedAttackVector;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.SummarizedCounterJsonMarshaller;
import java.util.List;

public class SummarizedAttackVectorJsonMarshaller {
    private static SummarizedAttackVectorJsonMarshaller instance;

    public void marshall(SummarizedAttackVector summarizedAttackVector, StructuredJsonGenerator jsonGenerator) {
        if (summarizedAttackVector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<SummarizedCounter> vectorCountersList;
            jsonGenerator.writeStartObject();
            if (summarizedAttackVector.getVectorType() != null) {
                jsonGenerator.writeFieldName("VectorType").writeValue(summarizedAttackVector.getVectorType());
            }
            if ((vectorCountersList = summarizedAttackVector.getVectorCounters()) != null) {
                jsonGenerator.writeFieldName("VectorCounters");
                jsonGenerator.writeStartArray();
                for (SummarizedCounter vectorCountersListValue : vectorCountersList) {
                    if (vectorCountersListValue == null) continue;
                    SummarizedCounterJsonMarshaller.getInstance().marshall(vectorCountersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SummarizedAttackVectorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SummarizedAttackVectorJsonMarshaller();
        }
        return instance;
    }
}

