/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.Attribute;
import com.amazonaws.services.directory.model.Computer;
import com.amazonaws.services.directory.model.transform.AttributeJsonMarshaller;

public class ComputerJsonMarshaller {
    private static ComputerJsonMarshaller instance;

    public void marshall(Computer computer, StructuredJsonGenerator jsonGenerator) {
        if (computer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList computerAttributesList;
            jsonGenerator.writeStartObject();
            if (computer.getComputerId() != null) {
                jsonGenerator.writeFieldName("ComputerId").writeValue(computer.getComputerId());
            }
            if (computer.getComputerName() != null) {
                jsonGenerator.writeFieldName("ComputerName").writeValue(computer.getComputerName());
            }
            if (!(computerAttributesList = (SdkInternalList)computer.getComputerAttributes()).isEmpty() || !computerAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComputerAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute computerAttributesListValue : computerAttributesList) {
                    if (computerAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(computerAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComputerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComputerJsonMarshaller();
        }
        return instance;
    }
}

