/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTarget;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;

public class MaintenanceWindowTargetJsonMarshaller {
    private static MaintenanceWindowTargetJsonMarshaller instance;

    public void marshall(MaintenanceWindowTarget maintenanceWindowTarget, StructuredJsonGenerator jsonGenerator) {
        if (maintenanceWindowTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList targetsList;
            jsonGenerator.writeStartObject();
            if (maintenanceWindowTarget.getWindowId() != null) {
                jsonGenerator.writeFieldName("WindowId").writeValue(maintenanceWindowTarget.getWindowId());
            }
            if (maintenanceWindowTarget.getWindowTargetId() != null) {
                jsonGenerator.writeFieldName("WindowTargetId").writeValue(maintenanceWindowTarget.getWindowTargetId());
            }
            if (maintenanceWindowTarget.getResourceType() != null) {
                jsonGenerator.writeFieldName("ResourceType").writeValue(maintenanceWindowTarget.getResourceType());
            }
            if (!(targetsList = (SdkInternalList)maintenanceWindowTarget.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (maintenanceWindowTarget.getOwnerInformation() != null) {
                jsonGenerator.writeFieldName("OwnerInformation").writeValue(maintenanceWindowTarget.getOwnerInformation());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MaintenanceWindowTargetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MaintenanceWindowTargetJsonMarshaller();
        }
        return instance;
    }
}

