/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskParameterValueExpression;
import com.amazonaws.services.simplesystemsmanagement.model.RegisterTaskWithMaintenanceWindowRequest;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.LoggingInfoJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaintenanceWindowTaskParameterValueExpressionJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class RegisterTaskWithMaintenanceWindowRequestMarshaller
implements Marshaller<Request<RegisterTaskWithMaintenanceWindowRequest>, RegisterTaskWithMaintenanceWindowRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RegisterTaskWithMaintenanceWindowRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterTaskWithMaintenanceWindowRequest> marshall(RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest) {
        if (registerTaskWithMaintenanceWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTaskWithMaintenanceWindowRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.RegisterTaskWithMaintenanceWindow");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, MaintenanceWindowTaskParameterValueExpression> taskParametersMap;
            SdkInternalList targetsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerTaskWithMaintenanceWindowRequest.getWindowId() != null) {
                jsonGenerator.writeFieldName("WindowId").writeValue(registerTaskWithMaintenanceWindowRequest.getWindowId());
            }
            if (!(targetsList = (SdkInternalList)registerTaskWithMaintenanceWindowRequest.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Object targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall((Target)targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (registerTaskWithMaintenanceWindowRequest.getTaskArn() != null) {
                jsonGenerator.writeFieldName("TaskArn").writeValue(registerTaskWithMaintenanceWindowRequest.getTaskArn());
            }
            if (registerTaskWithMaintenanceWindowRequest.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(registerTaskWithMaintenanceWindowRequest.getServiceRoleArn());
            }
            if (registerTaskWithMaintenanceWindowRequest.getTaskType() != null) {
                jsonGenerator.writeFieldName("TaskType").writeValue(registerTaskWithMaintenanceWindowRequest.getTaskType());
            }
            if ((taskParametersMap = registerTaskWithMaintenanceWindowRequest.getTaskParameters()) != null) {
                jsonGenerator.writeFieldName("TaskParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : taskParametersMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    MaintenanceWindowTaskParameterValueExpressionJsonMarshaller.getInstance().marshall((MaintenanceWindowTaskParameterValueExpression)entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (registerTaskWithMaintenanceWindowRequest.getPriority() != null) {
                jsonGenerator.writeFieldName("Priority").writeValue(registerTaskWithMaintenanceWindowRequest.getPriority().intValue());
            }
            if (registerTaskWithMaintenanceWindowRequest.getMaxConcurrency() != null) {
                jsonGenerator.writeFieldName("MaxConcurrency").writeValue(registerTaskWithMaintenanceWindowRequest.getMaxConcurrency());
            }
            if (registerTaskWithMaintenanceWindowRequest.getMaxErrors() != null) {
                jsonGenerator.writeFieldName("MaxErrors").writeValue(registerTaskWithMaintenanceWindowRequest.getMaxErrors());
            }
            if (registerTaskWithMaintenanceWindowRequest.getLoggingInfo() != null) {
                jsonGenerator.writeFieldName("LoggingInfo");
                LoggingInfoJsonMarshaller.getInstance().marshall(registerTaskWithMaintenanceWindowRequest.getLoggingInfo(), jsonGenerator);
            }
            jsonGenerator.writeFieldName("ClientToken").writeValue(IdempotentUtils.resolveString((String)registerTaskWithMaintenanceWindowRequest.getClientToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

