/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.waiters.DescribeAutoScalingGroupsFunction;
import com.amazonaws.services.autoscaling.waiters.GroupExists;
import com.amazonaws.services.autoscaling.waiters.GroupInService;
import com.amazonaws.services.autoscaling.waiters.GroupNotExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonAutoScalingWaiters {
    private final AmazonAutoScaling client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonAutoScalingWaiters(AmazonAutoScaling client) {
        this.client = client;
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupInService.IsFalseMatcher(), new GroupInService.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupNotExists.IsFalseMatcher(), new GroupNotExists.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupExists.IsTrueMatcher(), new GroupExists.IsFalseMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(10), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

