/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.BatchReadOperation;
import com.amazonaws.services.clouddirectory.model.BatchReadRequest;
import com.amazonaws.services.clouddirectory.model.transform.BatchReadOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class BatchReadRequestMarshaller
implements Marshaller<Request<BatchReadRequest>, BatchReadRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public BatchReadRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchReadRequest> marshall(BatchReadRequest batchReadRequest) {
        if (batchReadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchReadRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchReadRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)batchReadRequest.getDirectoryArn()));
        }
        if (batchReadRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString((String)batchReadRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/batchread";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<BatchReadOperation> operationsList = batchReadRequest.getOperations();
            if (operationsList != null) {
                jsonGenerator.writeFieldName("Operations");
                jsonGenerator.writeStartArray();
                for (BatchReadOperation operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    BatchReadOperationJsonMarshaller.getInstance().marshall(operationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

