/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.AttributeKey;
import com.amazonaws.services.clouddirectory.model.CreateIndexRequest;
import com.amazonaws.services.clouddirectory.model.transform.AttributeKeyJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateIndexRequestMarshaller
implements Marshaller<Request<CreateIndexRequest>, CreateIndexRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateIndexRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateIndexRequest> marshall(CreateIndexRequest createIndexRequest) {
        if (createIndexRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIndexRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createIndexRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)createIndexRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/index";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<AttributeKey> orderedIndexedAttributeListList = createIndexRequest.getOrderedIndexedAttributeList();
            if (orderedIndexedAttributeListList != null) {
                jsonGenerator.writeFieldName("OrderedIndexedAttributeList");
                jsonGenerator.writeStartArray();
                for (AttributeKey orderedIndexedAttributeListListValue : orderedIndexedAttributeListList) {
                    if (orderedIndexedAttributeListListValue == null) continue;
                    AttributeKeyJsonMarshaller.getInstance().marshall(orderedIndexedAttributeListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createIndexRequest.getIsUnique() != null) {
                jsonGenerator.writeFieldName("IsUnique").writeValue(createIndexRequest.getIsUnique().booleanValue());
            }
            if (createIndexRequest.getParentReference() != null) {
                jsonGenerator.writeFieldName("ParentReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(createIndexRequest.getParentReference(), jsonGenerator);
            }
            if (createIndexRequest.getLinkName() != null) {
                jsonGenerator.writeFieldName("LinkName").writeValue(createIndexRequest.getLinkName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

