/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Artwork;
import com.amazonaws.services.elastictranscoder.model.JobAlbumArt;
import com.amazonaws.services.elastictranscoder.model.transform.ArtworkJsonMarshaller;

public class JobAlbumArtJsonMarshaller {
    private static JobAlbumArtJsonMarshaller instance;

    public void marshall(JobAlbumArt jobAlbumArt, StructuredJsonGenerator jsonGenerator) {
        if (jobAlbumArt == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList artworkList;
            jsonGenerator.writeStartObject();
            if (jobAlbumArt.getMergePolicy() != null) {
                jsonGenerator.writeFieldName("MergePolicy").writeValue(jobAlbumArt.getMergePolicy());
            }
            if (!(artworkList = (SdkInternalList)jobAlbumArt.getArtwork()).isEmpty() || !artworkList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Artwork");
                jsonGenerator.writeStartArray();
                for (Artwork artworkListValue : artworkList) {
                    if (artworkListValue == null) continue;
                    ArtworkJsonMarshaller.getInstance().marshall(artworkListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobAlbumArtJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobAlbumArtJsonMarshaller();
        }
        return instance;
    }
}

