/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.Operator;

public class OperatorJsonMarshaller {
    private static OperatorJsonMarshaller instance;

    public void marshall(Operator operator, StructuredJsonGenerator jsonGenerator) {
        if (operator == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList valuesList;
            jsonGenerator.writeStartObject();
            if (operator.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(operator.getType());
            }
            if (!(valuesList = (SdkInternalList)operator.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("values");
                jsonGenerator.writeStartArray();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonGenerator.writeValue(valuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OperatorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OperatorJsonMarshaller();
        }
        return instance;
    }
}

