/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lexruntime.model.PostTextRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PostTextRequestMarshaller
implements Marshaller<Request<PostTextRequest>, PostTextRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PostTextRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PostTextRequest> marshall(PostTextRequest postTextRequest) {
        if (postTextRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)postTextRequest, "AmazonLexRuntime");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/bot/{botName}/alias/{botAlias}/user/{userId}/text";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "botName", postTextRequest.getBotName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "botAlias", postTextRequest.getBotAlias());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "userId", postTextRequest.getUserId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            Map<String, String> sessionAttributesMap = postTextRequest.getSessionAttributes();
            if (sessionAttributesMap != null) {
                jsonGenerator.writeFieldName("sessionAttributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> sessionAttributesMapValue : sessionAttributesMap.entrySet()) {
                    if (sessionAttributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(sessionAttributesMapValue.getKey());
                    jsonGenerator.writeValue(sessionAttributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (postTextRequest.getInputText() != null) {
                jsonGenerator.writeFieldName("inputText").writeValue(postTextRequest.getInputText());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

