/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.MessageBody;

public class MessageBodyJsonMarshaller {
    private static MessageBodyJsonMarshaller instance;

    public void marshall(MessageBody messageBody, StructuredJsonGenerator jsonGenerator) {
        if (messageBody == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (messageBody.getMessage() != null) {
                jsonGenerator.writeFieldName("Message").writeValue(messageBody.getMessage());
            }
            if (messageBody.getRequestID() != null) {
                jsonGenerator.writeFieldName("RequestID").writeValue(messageBody.getRequestID());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MessageBodyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MessageBodyJsonMarshaller();
        }
        return instance;
    }
}

