/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.MessageConfiguration;
import com.amazonaws.services.pinpoint.model.transform.MessageJsonMarshaller;

public class MessageConfigurationJsonMarshaller {
    private static MessageConfigurationJsonMarshaller instance;

    public void marshall(MessageConfiguration messageConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (messageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (messageConfiguration.getAPNSMessage() != null) {
                jsonGenerator.writeFieldName("APNSMessage");
                MessageJsonMarshaller.getInstance().marshall(messageConfiguration.getAPNSMessage(), jsonGenerator);
            }
            if (messageConfiguration.getDefaultMessage() != null) {
                jsonGenerator.writeFieldName("DefaultMessage");
                MessageJsonMarshaller.getInstance().marshall(messageConfiguration.getDefaultMessage(), jsonGenerator);
            }
            if (messageConfiguration.getGCMMessage() != null) {
                jsonGenerator.writeFieldName("GCMMessage");
                MessageJsonMarshaller.getInstance().marshall(messageConfiguration.getGCMMessage(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MessageConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MessageConfigurationJsonMarshaller();
        }
        return instance;
    }
}

