/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.Schedule;
import com.amazonaws.services.pinpoint.model.transform.QuietTimeJsonMarshaller;

public class ScheduleJsonMarshaller {
    private static ScheduleJsonMarshaller instance;

    public void marshall(Schedule schedule, StructuredJsonGenerator jsonGenerator) {
        if (schedule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (schedule.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(schedule.getEndTime());
            }
            if (schedule.getFrequency() != null) {
                jsonGenerator.writeFieldName("Frequency").writeValue(schedule.getFrequency());
            }
            if (schedule.getIsLocalTime() != null) {
                jsonGenerator.writeFieldName("IsLocalTime").writeValue(schedule.getIsLocalTime().booleanValue());
            }
            if (schedule.getQuietTime() != null) {
                jsonGenerator.writeFieldName("QuietTime");
                QuietTimeJsonMarshaller.getInstance().marshall(schedule.getQuietTime(), jsonGenerator);
            }
            if (schedule.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(schedule.getStartTime());
            }
            if (schedule.getTimezone() != null) {
                jsonGenerator.writeFieldName("Timezone").writeValue(schedule.getTimezone());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScheduleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScheduleJsonMarshaller();
        }
        return instance;
    }
}

