/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.LoadBalancer;

public class LoadBalancerJsonMarshaller {
    private static LoadBalancerJsonMarshaller instance;

    public void marshall(LoadBalancer loadBalancer, StructuredJsonGenerator jsonGenerator) {
        if (loadBalancer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (loadBalancer.getTargetGroupArn() != null) {
                jsonGenerator.writeFieldName("targetGroupArn").writeValue(loadBalancer.getTargetGroupArn());
            }
            if (loadBalancer.getLoadBalancerName() != null) {
                jsonGenerator.writeFieldName("loadBalancerName").writeValue(loadBalancer.getLoadBalancerName());
            }
            if (loadBalancer.getContainerName() != null) {
                jsonGenerator.writeFieldName("containerName").writeValue(loadBalancer.getContainerName());
            }
            if (loadBalancer.getContainerPort() != null) {
                jsonGenerator.writeFieldName("containerPort").writeValue(loadBalancer.getContainerPort().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LoadBalancerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerJsonMarshaller();
        }
        return instance;
    }
}

