/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.Difference;
import com.amazonaws.services.codecommit.model.transform.BlobMetadataJsonMarshaller;

public class DifferenceJsonMarshaller {
    private static DifferenceJsonMarshaller instance;

    public void marshall(Difference difference, StructuredJsonGenerator jsonGenerator) {
        if (difference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (difference.getBeforeBlob() != null) {
                jsonGenerator.writeFieldName("beforeBlob");
                BlobMetadataJsonMarshaller.getInstance().marshall(difference.getBeforeBlob(), jsonGenerator);
            }
            if (difference.getAfterBlob() != null) {
                jsonGenerator.writeFieldName("afterBlob");
                BlobMetadataJsonMarshaller.getInstance().marshall(difference.getAfterBlob(), jsonGenerator);
            }
            if (difference.getChangeType() != null) {
                jsonGenerator.writeFieldName("changeType").writeValue(difference.getChangeType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DifferenceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DifferenceJsonMarshaller();
        }
        return instance;
    }
}

