/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import java.util.List;

public class RepositoryTriggerJsonMarshaller {
    private static RepositoryTriggerJsonMarshaller instance;

    public void marshall(RepositoryTrigger repositoryTrigger, StructuredJsonGenerator jsonGenerator) {
        if (repositoryTrigger == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> eventsList;
            List<String> branchesList;
            jsonGenerator.writeStartObject();
            if (repositoryTrigger.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(repositoryTrigger.getName());
            }
            if (repositoryTrigger.getDestinationArn() != null) {
                jsonGenerator.writeFieldName("destinationArn").writeValue(repositoryTrigger.getDestinationArn());
            }
            if (repositoryTrigger.getCustomData() != null) {
                jsonGenerator.writeFieldName("customData").writeValue(repositoryTrigger.getCustomData());
            }
            if ((branchesList = repositoryTrigger.getBranches()) != null) {
                jsonGenerator.writeFieldName("branches");
                jsonGenerator.writeStartArray();
                for (String branchesListValue : branchesList) {
                    if (branchesListValue == null) continue;
                    jsonGenerator.writeValue(branchesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((eventsList = repositoryTrigger.getEvents()) != null) {
                jsonGenerator.writeFieldName("events");
                jsonGenerator.writeStartArray();
                for (String eventsListValue : eventsList) {
                    if (eventsListValue == null) continue;
                    jsonGenerator.writeValue(eventsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RepositoryTriggerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RepositoryTriggerJsonMarshaller();
        }
        return instance;
    }
}

