/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetModelsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetModelsRequestMarshaller
implements Marshaller<Request<GetModelsRequest>, GetModelsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetModelsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetModelsRequest> marshall(GetModelsRequest getModelsRequest) {
        if (getModelsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getModelsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getModelsRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (getModelsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getModelsRequest.getPosition()));
        }
        if (getModelsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getModelsRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

