/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.PutRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class PutRestApiRequestMarshaller
implements Marshaller<Request<PutRestApiRequest>, PutRestApiRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutRestApiRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutRestApiRequest> marshall(PutRestApiRequest putRestApiRequest) {
        Map<String, String> parameters;
        if (putRestApiRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", putRestApiRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (putRestApiRequest.getMode() != null) {
            request.addParameter("mode", StringUtils.fromString((String)putRestApiRequest.getMode()));
        }
        if (putRestApiRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean((Boolean)putRestApiRequest.getFailOnWarnings()));
        }
        if ((parameters = putRestApiRequest.getParameters()) != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString((String)entry.getKey()), StringUtils.fromString((String)entry.getValue()));
            }
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)putRestApiRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

