/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.ComputeEnvironmentOrder;
import com.amazonaws.services.batch.model.CreateJobQueueRequest;
import com.amazonaws.services.batch.model.transform.ComputeEnvironmentOrderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateJobQueueRequestMarshaller
implements Marshaller<Request<CreateJobQueueRequest>, CreateJobQueueRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateJobQueueRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateJobQueueRequest> marshall(CreateJobQueueRequest createJobQueueRequest) {
        if (createJobQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createJobQueueRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/createjobqueue";
        request.setResourcePath(uriResourcePath);
        try {
            List<ComputeEnvironmentOrder> computeEnvironmentOrderList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createJobQueueRequest.getJobQueueName() != null) {
                jsonGenerator.writeFieldName("jobQueueName").writeValue(createJobQueueRequest.getJobQueueName());
            }
            if (createJobQueueRequest.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(createJobQueueRequest.getState());
            }
            if (createJobQueueRequest.getPriority() != null) {
                jsonGenerator.writeFieldName("priority").writeValue(createJobQueueRequest.getPriority().intValue());
            }
            if ((computeEnvironmentOrderList = createJobQueueRequest.getComputeEnvironmentOrder()) != null) {
                jsonGenerator.writeFieldName("computeEnvironmentOrder");
                jsonGenerator.writeStartArray();
                for (ComputeEnvironmentOrder computeEnvironmentOrderListValue : computeEnvironmentOrderList) {
                    if (computeEnvironmentOrderListValue == null) continue;
                    ComputeEnvironmentOrderJsonMarshaller.getInstance().marshall(computeEnvironmentOrderListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

