/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.RegisterJobDefinitionRequest;
import com.amazonaws.services.batch.model.transform.ContainerPropertiesJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class RegisterJobDefinitionRequestMarshaller
implements Marshaller<Request<RegisterJobDefinitionRequest>, RegisterJobDefinitionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RegisterJobDefinitionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterJobDefinitionRequest> marshall(RegisterJobDefinitionRequest registerJobDefinitionRequest) {
        if (registerJobDefinitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerJobDefinitionRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/registerjobdefinition";
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> parametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerJobDefinitionRequest.getJobDefinitionName() != null) {
                jsonGenerator.writeFieldName("jobDefinitionName").writeValue(registerJobDefinitionRequest.getJobDefinitionName());
            }
            if (registerJobDefinitionRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(registerJobDefinitionRequest.getType());
            }
            if ((parametersMap = registerJobDefinitionRequest.getParameters()) != null) {
                jsonGenerator.writeFieldName("parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeValue(parametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (registerJobDefinitionRequest.getContainerProperties() != null) {
                jsonGenerator.writeFieldName("containerProperties");
                ContainerPropertiesJsonMarshaller.getInstance().marshall(registerJobDefinitionRequest.getContainerProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

