/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaEnumeration;

public class LabeledItemSet
extends ItemSet
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 4158771925518299903L;
    protected int m_classLabel;
    protected int m_ruleSupCounter;

    public LabeledItemSet(int totalTrans, int classLabel) {
        super(totalTrans);
        this.m_classLabel = classLabel;
    }

    public static ArrayList<Object> deleteItemSets(ArrayList<Object> itemSets, int minSupport, int maxSupport) {
        ArrayList<Object> newVector = new ArrayList<Object>(itemSets.size());
        for (int i = 0; i < itemSets.size(); ++i) {
            LabeledItemSet current = (LabeledItemSet)itemSets.get(i);
            if (current.m_ruleSupCounter < minSupport || current.m_ruleSupCounter > maxSupport) continue;
            newVector.add(current);
        }
        return newVector;
    }

    @Override
    public final boolean equals(Object itemSet) {
        if (!this.equalCondset(itemSet)) {
            return false;
        }
        return this.m_classLabel == ((LabeledItemSet)itemSet).m_classLabel;
    }

    public final boolean equalCondset(Object itemSet) {
        if (itemSet == null || !itemSet.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)itemSet).items().length) {
            return false;
        }
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i] == ((ItemSet)itemSet).itemAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Hashtable<ItemSet, Integer> getHashtable(ArrayList<Object> itemSets, int initialSize) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(initialSize);
        for (int i = 0; i < itemSets.size(); ++i) {
            LabeledItemSet current = (LabeledItemSet)itemSets.get(i);
            hashtable.put(current, new Integer(current.m_classLabel));
        }
        return hashtable;
    }

    public static ArrayList<Object> mergeAllItemSets(ArrayList<Object> itemSets, int size, int totalTrans) {
        ArrayList<Object> newVector = new ArrayList<Object>();
        block0: for (int i = 0; i < itemSets.size(); ++i) {
            LabeledItemSet first = (LabeledItemSet)itemSets.get(i);
            for (int j = i + 1; j < itemSets.size(); ++j) {
                LabeledItemSet second = (LabeledItemSet)itemSets.get(j);
                while (first.m_classLabel != second.m_classLabel) {
                    if (++j == itemSets.size()) continue block0;
                    second = (LabeledItemSet)itemSets.get(j);
                }
                LabeledItemSet result = new LabeledItemSet(totalTrans, first.m_classLabel);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) continue block0;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length && (first.m_items[k] == -1 || second.m_items[k] == -1)) {
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k != first.m_items.length) continue;
                result.m_ruleSupCounter = 0;
                result.m_counter = 0;
                newVector.add(result);
            }
        }
        return newVector;
    }

    public static Instances divide(Instances instances, boolean invert) throws Exception {
        Instances newInstances = new Instances(instances);
        if (instances.classIndex() < 0) {
            throw new Exception("For class association rule mining a class attribute has to be specified.");
        }
        if (invert) {
            for (int i = 0; i < newInstances.numAttributes(); ++i) {
                if (i == newInstances.classIndex()) continue;
                newInstances.deleteAttributeAt(i);
                --i;
            }
            return newInstances;
        }
        newInstances.setClassIndex(-1);
        newInstances.deleteAttributeAt(instances.classIndex());
        return newInstances;
    }

    public static ArrayList<Object> singletons(Instances instancesNoClass, Instances classes) throws Exception {
        ArrayList<Object> setOfItemSets = new ArrayList<Object>();
        for (int i = 0; i < instancesNoClass.numAttributes(); ++i) {
            if (instancesNoClass.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            for (int j = 0; j < instancesNoClass.attribute(i).numValues(); ++j) {
                for (int k = 0; k < classes.attribute(0).numValues(); ++k) {
                    LabeledItemSet current = new LabeledItemSet(instancesNoClass.numInstances(), k);
                    current.m_items = new int[instancesNoClass.numAttributes()];
                    for (int l = 0; l < instancesNoClass.numAttributes(); ++l) {
                        current.m_items[l] = -1;
                    }
                    current.m_items[i] = j;
                    setOfItemSets.add(current);
                }
            }
        }
        return setOfItemSets;
    }

    public static ArrayList<Object> pruneItemSets(ArrayList<Object> toPrune, Hashtable<ItemSet, Integer> kMinusOne) {
        ArrayList<Object> newVector = new ArrayList<Object>(toPrune.size());
        for (int i = 0; i < toPrune.size(); ++i) {
            int j;
            LabeledItemSet current = (LabeledItemSet)toPrune.get(i);
            for (j = 0; j < current.m_items.length; ++j) {
                if (current.m_items[j] == -1) continue;
                int help = current.m_items[j];
                current.m_items[j] = -1;
                if (kMinusOne.get(current) != null && current.m_classLabel == kMinusOne.get(current)) {
                    current.m_items[j] = help;
                    continue;
                }
                current.m_items[j] = help;
                break;
            }
            if (j != current.m_items.length) continue;
            newVector.add(current);
        }
        return newVector;
    }

    @Override
    public final int support() {
        return this.m_ruleSupCounter;
    }

    public final void upDateCounter(Instance instanceNoClass, Instance instanceClass) {
        if (this.containedBy(instanceNoClass)) {
            ++this.m_counter;
            if ((double)this.m_classLabel == instanceClass.value(0)) {
                ++this.m_ruleSupCounter;
            }
        }
    }

    public final void upDateCounterTreatZeroAsMissing(Instance instanceNoClass, Instance instanceClass) {
        if (this.containedByTreatZeroAsMissing(instanceNoClass)) {
            ++this.m_counter;
            if ((double)this.m_classLabel == instanceClass.value(0)) {
                ++this.m_ruleSupCounter;
            }
        }
    }

    public static void upDateCounters(ArrayList<Object> itemSets, Instances instancesNoClass, Instances instancesClass) {
        for (int i = 0; i < instancesNoClass.numInstances(); ++i) {
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(itemSets);
            while (enu.hasMoreElements()) {
                ((LabeledItemSet)enu.nextElement()).upDateCounter(instancesNoClass.instance(i), instancesClass.instance(i));
            }
        }
    }

    public static void upDateCountersTreatZeroAsMissing(ArrayList<LabeledItemSet> itemSets, Instances instancesNoClass, Instances instancesClass) {
        for (int i = 0; i < instancesNoClass.numInstances(); ++i) {
            WekaEnumeration<LabeledItemSet> enu = new WekaEnumeration<LabeledItemSet>(itemSets);
            while (enu.hasMoreElements()) {
                ((LabeledItemSet)enu.nextElement()).upDateCounterTreatZeroAsMissing(instancesNoClass.instance(i), instancesClass.instance(i));
            }
        }
    }

    public final ArrayList<Object>[] generateRules(double minConfidence, boolean noPrune) {
        ArrayList<ItemSet> premises = new ArrayList<ItemSet>();
        ArrayList<ItemSet> consequences = new ArrayList<ItemSet>();
        ArrayList<Double> conf = new ArrayList<Double>();
        ArrayList[] rules = new ArrayList[3];
        ItemSet premise = new ItemSet(this.m_totalTransactions);
        ItemSet consequence = new ItemSet(this.m_totalTransactions);
        int[] premiseItems = new int[this.m_items.length];
        int[] consequenceItems = new int[1];
        System.arraycopy(this.m_items, 0, premiseItems, 0, this.m_items.length);
        consequence.setItem(consequenceItems);
        premise.setItem(premiseItems);
        consequence.setItemAt(this.m_classLabel, 0);
        consequence.setCounter(this.m_ruleSupCounter);
        premise.setCounter(this.m_counter);
        premises.add(premise);
        consequences.add(consequence);
        conf.add(new Double((double)this.m_ruleSupCounter / (double)this.m_counter));
        rules[0] = premises;
        rules[1] = consequences;
        rules[2] = conf;
        if (!noPrune) {
            LabeledItemSet.pruneRules(rules, minConfidence);
        }
        return rules;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

