/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PrintableHandler;
import weka.gui.visualize.VisualizeUtils;

public class PrintableComponent
implements PrintableHandler {
    protected JComponent m_Component;
    protected static JFileChooser m_FileChooserPanel;
    protected static JCheckBox m_CustomDimensionsCheckBox;
    protected static JTextField m_CustomWidthText;
    protected static JTextField m_CustomHeightText;
    protected static JCheckBox m_AspectRatioCheckBox;
    protected String m_SaveDialogTitle = "Save as...";
    protected double m_xScale = 1.0;
    protected double m_yScale = 1.0;
    protected double m_AspectRatio;
    protected boolean m_IgnoreChange;
    private static final boolean DEBUG = false;
    protected static boolean m_ToolTipUserAsked;
    protected static final String PROPERTY_SHOW = "PrintableComponentToolTipShow";
    protected static final String PROPERTY_USERASKED = "PrintableComponentToolTipUserAsked";
    protected static boolean m_ShowToolTip;

    public PrintableComponent(JComponent component) {
        this.m_Component = component;
        this.m_AspectRatio = Double.NaN;
        this.getComponent().addMouseListener(new PrintMouseListener(this));
        this.getComponent().setToolTipText(PrintableComponent.getToolTipText(this));
        this.initFileChooser();
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    public static String getToolTipText(PrintableComponent component) {
        return null;
    }

    protected void initFileChooser() {
        if (m_FileChooserPanel != null) {
            return;
        }
        m_FileChooserPanel = new JFileChooser();
        m_FileChooserPanel.resetChoosableFileFilters();
        m_FileChooserPanel.setAcceptAllFileFilterUsed(false);
        JPanel accessory = new JPanel();
        accessory.setLayout(null);
        accessory.setPreferredSize(new Dimension(200, 200));
        accessory.revalidate();
        m_FileChooserPanel.setAccessory(accessory);
        m_CustomDimensionsCheckBox = new JCheckBox("Use custom dimensions");
        m_CustomDimensionsCheckBox.setBounds(14, 7, 200, 21);
        m_CustomDimensionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean custom = m_CustomDimensionsCheckBox.isSelected();
                m_CustomWidthText.setEnabled(custom);
                m_CustomHeightText.setEnabled(custom);
                m_AspectRatioCheckBox.setEnabled(custom);
                if (custom) {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("" + PrintableComponent.this.m_Component.getWidth());
                    m_CustomHeightText.setText("" + PrintableComponent.this.m_Component.getHeight());
                    PrintableComponent.this.m_IgnoreChange = false;
                } else {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("-1");
                    m_CustomHeightText.setText("-1");
                    PrintableComponent.this.m_IgnoreChange = false;
                }
            }
        });
        accessory.add(m_CustomDimensionsCheckBox);
        m_CustomWidthText = new JTextField(5);
        m_CustomWidthText.setText("-1");
        m_CustomWidthText.setEnabled(false);
        m_CustomWidthText.setBounds(65, 35, 50, 21);
        m_CustomWidthText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }
        });
        JLabel label = new JLabel("Width");
        label.setLabelFor(m_CustomWidthText);
        label.setDisplayedMnemonic('W');
        label.setBounds(14, 35, 50, 21);
        accessory.add(label);
        accessory.add(m_CustomWidthText);
        m_CustomHeightText = new JTextField(5);
        m_CustomHeightText.setText("-1");
        m_CustomHeightText.setEnabled(false);
        m_CustomHeightText.setBounds(65, 63, 50, 21);
        m_CustomHeightText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }
        });
        label = new JLabel("Height");
        label.setLabelFor(m_CustomHeightText);
        label.setDisplayedMnemonic('H');
        label.setBounds(14, 63, 50, 21);
        accessory.add(label);
        accessory.add(m_CustomHeightText);
        m_AspectRatioCheckBox = new JCheckBox("Keep aspect ratio");
        m_AspectRatioCheckBox.setBounds(14, 91, 200, 21);
        m_AspectRatioCheckBox.setEnabled(false);
        m_AspectRatioCheckBox.setSelected(true);
        m_AspectRatioCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean keep = m_AspectRatioCheckBox.isSelected();
                if (keep) {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("" + PrintableComponent.this.m_Component.getWidth());
                    m_CustomHeightText.setText("" + PrintableComponent.this.m_Component.getHeight());
                    PrintableComponent.this.m_IgnoreChange = false;
                }
            }
        });
        accessory.add(m_AspectRatioCheckBox);
        Vector<String> writerNames = GenericObjectEditor.getClassnames(JComponentWriter.class.getName());
        Collections.sort(writerNames);
        for (int i = 0; i < writerNames.size(); ++i) {
            try {
                Class<?> cls = Class.forName(writerNames.get(i).toString());
                JComponentWriter writer = (JComponentWriter)cls.newInstance();
                m_FileChooserPanel.addChoosableFileFilter(new JComponentWriterFileFilter(writer.getExtension(), writer.getDescription() + " (*" + writer.getExtension() + ")", writer));
                continue;
            }
            catch (Exception e) {
                System.err.println(writerNames.get(i) + ": " + e);
            }
        }
        if (m_FileChooserPanel.getChoosableFileFilters().length > 0) {
            m_FileChooserPanel.setFileFilter(m_FileChooserPanel.getChoosableFileFilters()[0]);
        }
    }

    protected void updateDimensions(JTextField sender) {
        int newValue;
        int baseValue;
        if (!m_AspectRatioCheckBox.isSelected() || this.m_IgnoreChange) {
            return;
        }
        if (!(sender instanceof JTextField) || sender == null) {
            return;
        }
        if (sender.getText().length() == 0) {
            return;
        }
        try {
            baseValue = Integer.parseInt(sender.getText());
            newValue = 0;
            if (baseValue <= 0) {
                return;
            }
            if (Double.isNaN(this.m_AspectRatio)) {
                this.m_AspectRatio = (double)this.getComponent().getWidth() / (double)this.getComponent().getHeight();
            }
        }
        catch (Exception e) {
            return;
        }
        this.m_IgnoreChange = true;
        if (sender == m_CustomWidthText) {
            newValue = (int)((double)baseValue * (1.0 / this.m_AspectRatio));
            m_CustomHeightText.setText("" + newValue);
        } else if (sender == m_CustomHeightText) {
            newValue = (int)((double)baseValue * this.m_AspectRatio);
            m_CustomWidthText.setText("" + newValue);
        }
        this.m_IgnoreChange = false;
    }

    @Override
    public Hashtable<String, JComponentWriter> getWriters() {
        Hashtable<String, JComponentWriter> result = new Hashtable<String, JComponentWriter>();
        for (int i = 0; i < m_FileChooserPanel.getChoosableFileFilters().length; ++i) {
            JComponentWriter writer = ((JComponentWriterFileFilter)m_FileChooserPanel.getChoosableFileFilters()[i]).getWriter();
            result.put(writer.getDescription(), writer);
        }
        return result;
    }

    @Override
    public JComponentWriter getWriter(String name) {
        return this.getWriters().get(name);
    }

    @Override
    public void setSaveDialogTitle(String title) {
        this.m_SaveDialogTitle = title;
    }

    @Override
    public String getSaveDialogTitle() {
        return this.m_SaveDialogTitle;
    }

    @Override
    public void setScale(double x, double y) {
        this.m_xScale = x;
        this.m_yScale = y;
    }

    @Override
    public double getXScale() {
        return this.m_xScale;
    }

    @Override
    public double getYScale() {
        return this.m_xScale;
    }

    @Override
    public void saveComponent() {
        m_FileChooserPanel.setDialogTitle(this.getSaveDialogTitle());
        do {
            int result;
            if ((result = m_FileChooserPanel.showSaveDialog(this.getComponent())) == 0) continue;
            return;
        } while (m_FileChooserPanel.getSelectedFile() == null);
        try {
            JComponentWriterFileFilter filter = (JComponentWriterFileFilter)m_FileChooserPanel.getFileFilter();
            File file = m_FileChooserPanel.getSelectedFile();
            JComponentWriter writer = filter.getWriter();
            if (!file.getAbsolutePath().toLowerCase().endsWith(writer.getExtension().toLowerCase())) {
                file = new File(file.getAbsolutePath() + writer.getExtension());
            }
            writer.setComponent(this.getComponent());
            writer.setFile(file);
            writer.setScale(this.getXScale(), this.getYScale());
            writer.setUseCustomDimensions(m_CustomDimensionsCheckBox.isSelected());
            if (m_CustomDimensionsCheckBox.isSelected()) {
                writer.setCustomWidth(Integer.parseInt(m_CustomWidthText.getText()));
                writer.setCustomHeight(Integer.parseInt(m_CustomHeightText.getText()));
            } else {
                writer.setCustomWidth(-1);
                writer.setCustomHeight(-1);
            }
            writer.toOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        m_ToolTipUserAsked = false;
        m_ShowToolTip = true;
        try {
            m_ShowToolTip = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_SHOW, "true"));
            m_ToolTipUserAsked = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_USERASKED, "false"));
        }
        catch (Exception e) {
            m_ToolTipUserAsked = false;
            m_ShowToolTip = true;
        }
    }

    private class PrintMouseListener
    extends MouseAdapter {
        private final PrintableComponent m_Component;

        public PrintMouseListener(PrintableComponent component) {
            this.m_Component = component;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int modifiers = e.getModifiers();
            if ((modifiers & 1) == 1 && (modifiers & 8) == 8 && (modifiers & 0x10) == 16) {
                e.consume();
                this.m_Component.saveComponent();
            }
        }
    }

    protected class JComponentWriterFileFilter
    extends ExtensionFileFilter {
        private static final long serialVersionUID = 8540426888094207515L;
        private final JComponentWriter m_Writer;

        public JComponentWriterFileFilter(String extension, String description, JComponentWriter writer) {
            super(extension, description);
            this.m_Writer = writer;
        }

        public JComponentWriter getWriter() {
            return this.m_Writer;
        }
    }
}

