/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts;

import java.io.IOException;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.ComponentGrouping;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.SmartsStereoMatch;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class SmartsPattern
extends Pattern {
    private final IAtomContainer query;
    private final Pattern pattern;
    private final boolean ringInfo;
    private final Aromaticity arom = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.relevant()));

    private SmartsPattern(String smarts, IChemObjectBuilder builder) throws IOException {
        try {
            this.query = SMARTSParser.parse(smarts, builder);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.pattern = Pattern.findSubstructure(this.query);
        this.ringInfo = SmartsPattern.ringSizeOrNumber(smarts);
    }

    @Override
    public int[] match(IAtomContainer container) {
        return this.matchAll(container).first();
    }

    @Override
    public Mappings matchAll(IAtomContainer target) {
        SmartsMatchers.prepare(target, this.ringInfo);
        try {
            this.arom.apply(target);
        }
        catch (CDKException e) {
            LoggingToolFactory.createLoggingTool(this.getClass()).error(e);
        }
        Mappings mappings = this.pattern.matchAll(target);
        if (this.query.stereoElements().iterator().hasNext()) {
            mappings = mappings.filter(new SmartsStereoMatch(this.query, target));
        }
        if (this.query.getProperty("COMPONENT.GROUPING") != null) {
            mappings = mappings.filter(new ComponentGrouping(this.query, target));
        }
        return mappings;
    }

    public static SmartsPattern create(String smarts, IChemObjectBuilder builder) throws IOException {
        return new SmartsPattern(smarts, builder);
    }

    static boolean ringSizeOrNumber(String smarts) {
        int end = smarts.length() - 1;
        for (int i = 0; i <= end; ++i) {
            char c = smarts.charAt(i);
            if ((c == 'r' || c == 'R') && i < end && Character.isDigit(smarts.charAt(i + 1))) {
                return true;
            }
            if (c != '!' || i >= end || smarts.charAt(i + 1) != 'R') continue;
            return true;
        }
        return false;
    }
}

