/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import edu.cens.spatial.DeducerDataFrameNameField;
import edu.cens.spatial.DeducerOkCancelPanel;
import edu.cens.spatial.plots.MapController;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AcceptSubsetDialog
extends JDialog {
    private static final String HELP_URL = "http://www.deducer.org/pmwiki/index.php?n=Main.DeducerSpatial";
    private final MapController mc;
    private boolean keepSelected = true;
    DeducerDataFrameNameField nameField;

    public AcceptSubsetDialog(JFrame jFrame, final MapController mapController) {
        super(jFrame);
        this.mc = mapController;
        this.setModal(false);
        this.nameField = new DeducerDataFrameNameField();
        this.nameField.setText("tmp");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                mapController.stopSubsetting();
            }
        });
        this.initGui();
    }

    private void initGui() {
        final AcceptSubsetDialog acceptSubsetDialog = this;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        final JRadioButton jRadioButton = new JRadioButton("Keep Only Selected");
        final JRadioButton jRadioButton2 = new JRadioButton("Delete Selected");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcceptSubsetDialog.this.keepSelected = jRadioButton.isSelected();
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcceptSubsetDialog.this.keepSelected = !jRadioButton2.isSelected();
            }
        });
        jRadioButton.setSelected(true);
        this.nameField.setPreferredSize(new Dimension(250, this.nameField.getPreferredSize().height));
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)jRadioButton2, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel("Subset Name:"), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        DeducerOkCancelPanel deducerOkCancelPanel = new DeducerOkCancelPanel(this.rootPane){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void ok() {
                try {
                    this.setCursor(new Cursor(3));
                    AcceptSubsetDialog.this.mc.executeSubsetting(AcceptSubsetDialog.this.keepSelected, AcceptSubsetDialog.this.nameField.getText());
                    acceptSubsetDialog.setVisible(false);
                }
                finally {
                    this.setCursor(new Cursor(0));
                }
            }

            protected void cancel() {
                AcceptSubsetDialog.this.mc.stopSubsetting();
                acceptSubsetDialog.setVisible(false);
            }
        };
        deducerOkCancelPanel.setHelpUrl(HELP_URL);
        this.add((Component)deducerOkCancelPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        this.pack();
        this.setResizable(false);
    }

    public void setVisible(boolean bl) {
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        AcceptSubsetDialog acceptSubsetDialog = new AcceptSubsetDialog(null, null){

            public void setVisible(boolean bl) {
                if (!bl) {
                    System.exit(0);
                }
                super.setVisible(bl);
            }
        };
        acceptSubsetDialog.removeWindowListener(acceptSubsetDialog.getWindowListeners()[0]);
        acceptSubsetDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Dialog)acceptSubsetDialog).setVisible(true);
    }
}

