/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$kafka$log$LogManager$;
import kafka.log.LogSegment;
import kafka.server.OffsetCheckpoint;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u00151{w-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"AQ\u0004\u0001BC\u0002\u0013\u0005a$A\u0004m_\u001e$\u0015N]:\u0016\u0003}\u00012a\u0006\u0011#\u0013\t\t\u0003DA\u0003BeJ\f\u0017\u0010\u0005\u0002$M5\tAE\u0003\u0002&\u0019\u0005\u0011\u0011n\\\u0005\u0003O\u0011\u0012AAR5mK\"A\u0011\u0006\u0001B\u0001B\u0003%q$\u0001\u0005m_\u001e$\u0015N]:!\u0011!Y\u0003A!b\u0001\n\u0003a\u0013\u0001\u0004;pa&\u001c7i\u001c8gS\u001e\u001cX#A\u0017\u0011\t9\n4GO\u0007\u0002_)\u0011\u0001\u0007G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001a0\u0005\ri\u0015\r\u001d\t\u0003i]r!aF\u001b\n\u0005YB\u0012A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\r\u0011\u0005mbT\"\u0001\u0002\n\u0005u\u0012!!\u0003'pO\u000e{gNZ5h\u0011!y\u0004A!A!\u0002\u0013i\u0013!\u0004;pa&\u001c7i\u001c8gS\u001e\u001c\b\u0005\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u00035!WMZ1vYR\u001cuN\u001c4jOV\t!\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003;\u00039!WMZ1vYR\u001cuN\u001c4jO\u0002B\u0001B\u0012\u0001\u0003\u0006\u0004%\taR\u0001\u000eG2,\u0017M\\3s\u0007>tg-[4\u0016\u0003!\u0003\"aO%\n\u0005)\u0013!!D\"mK\u0006tWM]\"p]\u001aLw\r\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003I\u00039\u0019G.Z1oKJ\u001cuN\u001c4jO\u0002B\u0001B\u0014\u0001\u0003\u0006\u0004%\taT\u0001\rM2,8\u000f[\"iK\u000e\\Wj]\u000b\u0002!B\u0011q#U\u0005\u0003%b\u0011A\u0001T8oO\"AA\u000b\u0001B\u0001B\u0003%\u0001+A\u0007gYV\u001c\bn\u00115fG.l5\u000f\t\u0005\t-\u0002\u0011)\u0019!C\u0001\u001f\u0006\tb\r\\;tQ\u000eCWmY6q_&tG/T:\t\u0011a\u0003!\u0011!Q\u0001\nA\u000b!C\u001a7vg\"\u001c\u0005.Z2la>Lg\u000e^'tA!A!\f\u0001BC\u0002\u0013\u0005q*\u0001\tsKR,g\u000e^5p]\u000eCWmY6Ng\"AA\f\u0001B\u0001B\u0003%\u0001+A\tsKR,g\u000e^5p]\u000eCWmY6Ng\u0002B\u0001B\u0018\u0001\u0003\u0002\u0003\u0006IaX\u0001\ng\u000eDW\rZ;mKJ\u0004\"!\u00051\n\u0005\u0005\u0014\"!C*dQ\u0016$W\u000f\\3s\u0011!\u0019\u0007A!b\u0001\n\u0013!\u0017\u0001\u0002;j[\u0016,\u0012!\u001a\t\u0003#\u0019L!a\u001a\n\u0003\tQKW.\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005K\u0006)A/[7fA!)1\u000e\u0001C\u0001Y\u00061A(\u001b8jiz\"\"\"\u001c8paF\u00148\u000f^;w!\tY\u0004\u0001C\u0003\u001eU\u0002\u0007q\u0004C\u0003,U\u0002\u0007Q\u0006C\u0003BU\u0002\u0007!\bC\u0003GU\u0002\u0007\u0001\nC\u0003OU\u0002\u0007\u0001\u000bC\u0003WU\u0002\u0007\u0001\u000bC\u0003[U\u0002\u0007\u0001\u000bC\u0003_U\u0002\u0007q\fC\u0003dU\u0002\u0007Q\rC\u0004y\u0001\t\u0007I\u0011A=\u00027I+7m\u001c<fef\u0004v.\u001b8u\u0007\",7m\u001b9pS:$h)\u001b7f+\u0005Q\bCA\u0005|\u0013\tA$\u0002\u0003\u0004~\u0001\u0001\u0006IA_\u0001\u001d%\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3!\u0011\u001dy\bA1A\u0005\u0002e\f\u0001\u0002T8dW\u001aKG.\u001a\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003{\u0003%aunY6GS2,\u0007\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001\u0002\n\u0005\u0011\u0012J\\5uS\u0006dG+Y:l\t\u0016d\u0017-_'t+\t\tY\u0001E\u0002\u0018\u0003\u001bI1!a\u0004\u0019\u0005\rIe\u000e\u001e\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\f\u0005\u0019\u0012J\\5uS\u0006dG+Y:l\t\u0016d\u0017-_'tA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\u001aY><7I]3bi&|gn\u0014:EK2,G/[8o\u0019>\u001c7.F\u0001\t\u0011\u001d\ti\u0002\u0001Q\u0001\n!\t!\u0004\\8h\u0007J,\u0017\r^5p]>\u0013H)\u001a7fi&|g\u000eT8dW\u0002B\u0011\"!\t\u0001\u0005\u0004%I!a\t\u0002\t1|wm]\u000b\u0003\u0003K\u0001r!EA\u0014\u0003W\t9$C\u0002\u0002*I\u0011A\u0001U8pYB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022\u0011\taaY8n[>t\u0017\u0002BA\u001b\u0003_\u0011\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\rY\u0014\u0011H\u0005\u0004\u0003w\u0011!a\u0001'pO\"A\u0011q\b\u0001!\u0002\u0013\t)#A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F\u0005AA-\u001b:M_\u000e\\7/\u0006\u0002\u0002HA)a&!\u0013\u0002N%\u0019\u00111J\u0018\u0003\u0007M+\u0017\u000fE\u0002\u0012\u0003\u001fJ1!!\u0015\u0013\u0005!1\u0015\u000e\\3M_\u000e\\\u0007\u0002CA+\u0001\u0001\u0006I!a\u0012\u0002\u0013\u0011L'\u000fT8dWN\u0004\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0003a\u0011XmY8wKJL\bk\\5oi\u000eCWmY6q_&tGo]\u000b\u0003\u0003;\u0002r!a\u0018\u0002f\t\n9'\u0004\u0002\u0002b)\u0019\u00111M\u0018\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u001a\u0002bA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n\u0011\taa]3sm\u0016\u0014\u0018\u0002BA9\u0003W\u0012\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\t\u0011\u0005U\u0004\u0001)A\u0005\u0003;\n\u0011D]3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;tA!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111P\u0001\bG2,\u0017M\\3s+\t\ti\bE\u0002<\u0003\u007fJ1!!!\u0003\u0005)aunZ\"mK\u0006tWM\u001d\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002~\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0004\u0002\n\u0002!I!a#\u00021\r\u0014X-\u0019;f\u0003:$g+\u00197jI\u0006$X\rT8h\t&\u00148\u000f\u0006\u0003\u0002\u000e\u0006M\u0005cA\f\u0002\u0010&\u0019\u0011\u0011\u0013\r\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u000b9\t1\u0001\u0002\u0018\u0006!A-\u001b:t!\u0011q\u0013\u0011\n\u0012\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006YAn\\2l\u0019><G)\u001b:t)\u0011\t9%a(\t\u0011\u0005U\u0015\u0011\u0014a\u0001\u0003/Cq!a)\u0001\t\u0013\t)+\u0001\u0005m_\u0006$Gj\\4t)\u0011\ti)a*\t\u0011\u0005U\u0015\u0011\u0015a\u0001\u0003/Cq!a+\u0001\t\u0003\ti+A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u00055\u0005bBAY\u0001\u0011\u0005\u0011QV\u0001\tg\",H\u000fZ8x]\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QRA]\u0011!\tY,a-A\u0002\u0005u\u0016a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\b#\u0002\u00182\u0003W\u0001\u0006bBAa\u0001\u0011\u0005\u00111Y\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!$\u0002F\u0006%\u0007\u0002CAd\u0003\u007f\u0003\r!a\u000b\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002L\u0006}\u0006\u0019\u0001)\u0002\u00139,wo\u00144gg\u0016$\bbBAh\u0001\u0011\u0005\u0011QV\u0001\u001fG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R|eMZ:fiNDq!a5\u0001\t\u0003\t).\u0001\u0004hKRdun\u001a\u000b\u0005\u0003/\fi\u000eE\u0003\u0018\u00033\f9$C\u0002\u0002\\b\u0011aa\u00149uS>t\u0007\u0002CAd\u0003#\u0004\r!a\u000b\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\u0006I1M]3bi\u0016dun\u001a\u000b\u0007\u0003o\t)/a:\t\u0011\u0005\u001d\u0017q\u001ca\u0001\u0003WAq!!;\u0002`\u0002\u0007!(\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003[\u0004A\u0011AAx\u0003%!W\r\\3uK2{w\r\u0006\u0003\u0002\u000e\u0006E\b\u0002CAd\u0003W\u0004\r!a\u000b\t\u000f\u0005U\b\u0001\"\u0003\u0002x\u0006Qa.\u001a=u\u0019><G)\u001b:\u0015\u0003\tBq!a?\u0001\t\u0013\ti0\u0001\fdY\u0016\fg.\u001e9FqBL'/\u001a3TK\u001elWM\u001c;t)\u0011\tY!a@\t\u000f\r\tI\u00101\u0001\u00028!9!1\u0001\u0001\u0005\n\t\u0015\u0011!H2mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3\u0015\t\u0005-!q\u0001\u0005\b\u0007\t\u0005\u0001\u0019AA\u001c\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003[\u000b1b\u00197fC:,\b\u000fT8hg\"9!q\u0002\u0001\u0005\u0002\tE\u0011aB1mY2{wm\u001d\u000b\u0003\u0005'\u0001RA\fB\u000b\u0003oI1Aa\u00060\u0005!IE/\u001a:bE2,\u0007b\u0002B\u000e\u0001\u0011\u0005!QD\u0001\u0015Y><7OQ=U_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\t}\u0001\u0003CA0\u0003K\nY#a\u000e\t\u000f\t\r\u0002\u0001\"\u0003\u0002.\u0006qa\r\\;tQ\u0012K'\u000f^=M_\u001e\u001c\bf\u0001\u0001\u0003(A\u0019\u0011C!\u000b\n\u0007\t-\"C\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogManager
implements Logging,
ScalaObject {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    public final Scheduler kafka$log$LogManager$$scheduler;
    private final Time kafka$log$LogManager$$time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool kafka$log$LogManager$$logs;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map kafka$log$LogManager$$recoveryPointCheckpoints;
    private final LogCleaner kafka$log$LogManager$$cleaner;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    public final Pool kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    public final scala.collection.immutable.Map kafka$log$LogManager$$recoveryPointCheckpoints() {
        return this.kafka$log$LogManager$$recoveryPointCheckpoints;
    }

    public final LogCleaner kafka$log$LogManager$$cleaner() {
        return this.kafka$log$LogManager$$cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map(new $anonfun$createAndValidateLogDirs$1(this), Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        dirs.foreach(new $anonfun$createAndValidateLogDirs$2(this));
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return dirs.map(new $anonfun$lockLogDirs$1(this), Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs(Seq<File> dirs) {
        dirs.foreach(new $anonfun$loadLogs$1(this));
    }

    public void startup() {
        if (this.kafka$log$LogManager$$scheduler != null) {
            this.info((Function0<String>)new $anonfun$startup$4(this));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-retention", new $anonfun$startup$1(this), this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
            this.info((Function0<String>)new $anonfun$startup$5(this));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-flusher", new $anonfun$startup$2(this), this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-recovery-point-checkpoint", new $anonfun$startup$3(this), this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
        }
        if (this.cleanerConfig().enableCleaner()) {
            this.kafka$log$LogManager$$cleaner().startup();
        }
    }

    public void shutdown() {
        this.debug((Function0<String>)new $anonfun$shutdown$2(this));
        try {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$shutdown$1(this));
            }
            this.allLogs().foreach(new $anonfun$shutdown$3(this));
            this.allLogs().foreach(new $anonfun$shutdown$4(this));
            this.checkpointRecoveryPointOffsets();
            Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new $anonfun$shutdown$5(this));
            this.debug((Function0<String>)new $anonfun$shutdown$7(this));
            return;
        }
        finally {
            this.dirLocks().foreach(new $anonfun$shutdown$6(this));
        }
    }

    public void truncateTo(Map<TopicAndPartition, Long> partitionAndOffsets) {
        partitionAndOffsets.foreach(new $anonfun$truncateTo$1(this));
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicAndPartition topicAndPartition, long newOffset) {
        Log log2 = (Log)this.kafka$log$LogManager$$logs().get(topicAndPartition);
        if (log2 != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortAndPauseCleaning(topicAndPartition);
            }
            log2.truncateFullyAndStartAt(newOffset);
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().resumeCleaning(topicAndPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        scala.collection.immutable.Map recoveryPointsByDir$1 = this.logsByTopicPartition().groupBy(new $anonfun$4(this));
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new $anonfun$checkpointRecoveryPointOffsets$1(this, recoveryPointsByDir$1));
    }

    public Option<Log> getLog(TopicAndPartition topicAndPartition) {
        Log log2 = (Log)this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log2 == null ? None$.MODULE$ : new Some<Log>(log2);
    }

    public Log createLog(TopicAndPartition topicAndPartition$1, LogConfig config$1) {
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            Log log2;
            block4: {
                log2 = (Log)this.kafka$log$LogManager$$logs().get(topicAndPartition$1);
                if (log2 != null) break block4;
                File dataDir$1 = this.nextLogDir();
                File dir = new File(dataDir$1, new StringBuilder().append((Object)topicAndPartition$1.topic()).append((Object)"-").append(BoxesRunTime.boxToInteger(topicAndPartition$1.partition())).toString());
                dir.mkdirs();
                log2 = new Log(dir, config$1, 0L, this.kafka$log$LogManager$$scheduler, this.kafka$log$LogManager$$time());
                this.kafka$log$LogManager$$logs().put(topicAndPartition$1, log2);
                this.info((Function0<String>)new $anonfun$createLog$1(this, topicAndPartition$1, config$1, dataDir$1));
                Log log3 = log2;
                return log3;
            }
            return log2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteLog(TopicAndPartition topicAndPartition$2) {
        ObjectRef removedLog$1 = new ObjectRef(null);
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            removedLog$1.elem = (Log)this.kafka$log$LogManager$$logs().remove(topicAndPartition$2);
        }
        if ((Log)removedLog$1.elem != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortCleaning(topicAndPartition$2);
            }
            ((Log)removedLog$1.elem).delete();
            this.info((Function0<String>)new $anonfun$deleteLog$1(this, topicAndPartition$2, removedLog$1));
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy(new $anonfun$5(this)).mapValues(new $anonfun$6(this));
            scala.collection.immutable.Map zeros = Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map(new $anonfun$7(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, ClassManifest$.MODULE$.classType(String.class), Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).toMap(Predef$.MODULE$.conforms());
            Buffer<Integer> dirCounts = zeros.$plus$plus(logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy(new $anonfun$8(this), Ordering$Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public final int kafka$log$LogManager$$cleanupExpiredSegments(Log log$2) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        return log$2.deleteOldSegments(new $anonfun$kafka$log$LogManager$$cleanupExpiredSegments$1(this, log$2, startMs$1));
    }

    public final int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log2) {
        if (log2.config().retentionSize() < 0L || log2.size() < log2.config().retentionSize()) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log2.size() - log2.config().retentionSize());
        return log2.deleteOldSegments(new $anonfun$kafka$log$LogManager$$cleanupSegmentsToMaintainSize$1(this, diff$1));
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new $anonfun$cleanupLogs$1(this));
        IntRef total$1 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().withFilter(new $anonfun$cleanupLogs$2(this)).foreach(new $anonfun$cleanupLogs$3(this, total$1));
        this.debug((Function0<String>)new $anonfun$cleanupLogs$4(this, total$1, startMs$2));
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public scala.collection.immutable.Map<TopicAndPartition, Log> logsByTopicPartition() {
        return this.kafka$log$LogManager$$logs().toMap(Predef$.MODULE$.conforms());
    }

    public final void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)new $anonfun$kafka$log$LogManager$$flushDirtyLogs$1(this));
        this.kafka$log$LogManager$$logs().foreach(new $anonfun$kafka$log$LogManager$$flushDirtyLogs$2(this));
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.kafka$log$LogManager$$scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.init$default$1());
        this.createAndValidateLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$recoveryPointCheckpoints = Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])logDirs).map(new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, ClassManifest$.MODULE$.classType(File.class), Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(OffsetCheckpoint.class)}))))).toMap(Predef$.MODULE$.conforms());
        this.loadLogs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.kafka$log$LogManager$$logs(), time) : null;
    }
}

