/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import kafka.common.TopicAndPartition;
import kafka.server.OffsetCheckpoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u000113\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u0011\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0001b\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aC*dC2\fwJ\u00196fGRD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0005M&dW-F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011C\"\u0001\u0002j_&\u0011A%\t\u0002\u0005\r&dW\r\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003 \u0003\u00151\u0017\u000e\\3!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\u0011!\u0006\f\t\u0003W\u0001i\u0011A\u0001\u0005\u0006;\u001d\u0002\ra\b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0003\u0011awnY6\u0016\u0003!Aa!\r\u0001!\u0002\u0013A\u0011!\u00027pG.\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014!B<sSR,GCA\u001b9!\t9b'\u0003\u000281\t!QK\\5u\u0011\u0015I$\u00071\u0001;\u0003\u001dygMZ:fiN\u0004Ba\u000f A\r6\tAH\u0003\u0002>1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005}b$aA'baB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tB\u0001\u0007G>lWn\u001c8\n\u0005\u0015\u0013%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011qcR\u0005\u0003\u0011b\u0011A\u0001T8oO\")!\n\u0001C\u0001\u0017\u0006!!/Z1e)\u0005Q\u0004")
public class OffsetCheckpoint
implements Logging,
ScalaObject {
    private final File file;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetCheckpoint offsetCheckpoint = this;
        synchronized (offsetCheckpoint) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Map<TopicAndPartition, Long> offsets$1) {
        Object object = this.lock();
        synchronized (object) {
            File temp;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        temp = new File(new StringBuilder().append((Object)this.file().getAbsolutePath()).append((Object)".tmp").toString());
                        BufferedWriter writer$1 = new BufferedWriter(new FileWriter(temp));
                        this.liftedTree1$1(offsets$1, writer$1);
                        if (!temp.renameTo(this.file())) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    this.file().delete();
                    if (!temp.renameTo(this.file())) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new IOException(Predef$.MODULE$.augmentString("File rename from %s to %s failed.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{temp.getAbsolutePath(), this.file().getAbsolutePath()})));
        }
    }

    public Map<TopicAndPartition, Long> read() {
        NonLocalReturnControl nonLocalReturnControl2;
        block6: {
            Object object = new Object();
            Map exceptionResult1 = null;
            try {
                Object object2 = this.lock();
                synchronized (object2) {
                    BufferedReader reader$1 = new BufferedReader(new FileReader(this.file()));
                    Map map2 = this.liftedTree2$1(reader$1, object);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    exceptionResult1 = map2;
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block6;
                exceptionResult1 = (Map)nonLocalReturnControl2.value();
            }
            return exceptionResult1;
        }
        throw nonLocalReturnControl2;
    }

    private final void liftedTree1$1(Map map2, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger(0)).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger(map2.size())).toString());
            bufferedWriter.newLine();
            map2.foreach(new $anonfun$liftedTree1$1$1(this, bufferedWriter));
            bufferedWriter.flush();
            return;
        }
        finally {
            bufferedWriter.close();
        }
    }

    private final Map liftedTree2$1(BufferedReader bufferedReader, Object object) {
        Map exceptionResult2 = null;
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                throw new NonLocalReturnControl<Map>(object, Map$.MODULE$.empty());
            }
            int version = Predef$.MODULE$.augmentString(line).toInt();
            int n = version;
            if (n == 0) {
                line = bufferedReader.readLine();
                if (line == null) {
                    throw new NonLocalReturnControl<Map>(object, Map$.MODULE$.empty());
                }
                int expectedSize = Predef$.MODULE$.augmentString(line).toInt();
                Object offsets = Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                line = bufferedReader.readLine();
                while (true) {
                    if (line == null) {
                        if (offsets.size() != expectedSize) {
                            throw new IOException(Predef$.MODULE$.augmentString("Expected %d entries but found only %d").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(expectedSize), BoxesRunTime.boxToInteger(offsets.size())})));
                        }
                        exceptionResult2 = (Map)offsets;
                        return exceptionResult2;
                    }
                    String[] pieces = line.split("\\s+");
                    if (pieces.length != 3) {
                        throw new IOException(Predef$.MODULE$.augmentString("Malformed line in offset checkpoint file: '%s'.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{line})));
                    }
                    String topic = pieces[0];
                    int partition2 = Predef$.MODULE$.augmentString(pieces[1]).toInt();
                    long offset = Predef$.MODULE$.augmentString(pieces[2]).toLong();
                    offsets = offsets.$plus(Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(topic, partition2)).$minus$greater(BoxesRunTime.boxToLong(offset)));
                    line = bufferedReader.readLine();
                }
            }
            throw new IOException(new StringBuilder().append((Object)"Unrecognized version of the highwatermark checkpoint file: ").append(BoxesRunTime.boxToInteger(version)).toString());
        }
        finally {
            bufferedReader.close();
        }
    }

    public OffsetCheckpoint(File file) {
        this.file = file;
        Logging$class.$init$(this);
        this.lock = new Object();
        new File(Predef$.MODULE$.any2stringadd(file).$plus(".tmp")).delete();
        file.createNewFile();
    }
}

