/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.HashSet;
import java.util.Map;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DataTreeMXBean;

public class DataTreeBean
implements DataTreeMXBean,
ZKMBeanInfo {
    DataTree dataTree;

    public DataTreeBean(DataTree dataTree) {
        this.dataTree = dataTree;
    }

    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    public long approximateDataSize() {
        return this.dataTree.approximateDataSize();
    }

    public int countEphemerals() {
        Map<Long, HashSet<String>> map2 = this.dataTree.getEphemeralsMap();
        int result2 = 0;
        for (HashSet<String> set : map2.values()) {
            result2 += set.size();
        }
        return result2;
    }

    public int getWatchCount() {
        return this.dataTree.getWatchCount();
    }

    public String getName() {
        return "InMemoryDataTree";
    }

    public boolean isHidden() {
        return false;
    }

    public String getLastZxid() {
        return "0x" + Long.toHexString(this.dataTree.lastProcessedZxid);
    }
}

