/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.util.Properties;
import ome.conditions.ApiUsageException;

public class Login {
    public static final String OMERO_USER = "omero.user";
    public static final String OMERO_GROUP = "omero.group";
    public static final String OMERO_PASS = "omero.pass";
    public static final String OMERO_EVENT = "omero.event";
    public static final Login GUEST = new Login(){

        @Override
        public Properties asProperties() {
            Properties p = super.asProperties();
            p.setProperty(Login.OMERO_USER, null);
            p.setProperty(Login.OMERO_PASS, null);
            p.setProperty(Login.OMERO_GROUP, null);
            p.setProperty(Login.OMERO_EVENT, null);
            return p;
        }
    };
    private String _user;
    private String _group;
    private String _pass;
    private String _event;

    private Login() {
    }

    public Login(String user, String password) {
        if (user == null || password == null) {
            throw new ApiUsageException("User and password arguments to Login constructor cannot be null");
        }
        this._user = user;
        this._pass = password;
    }

    public Login(String user, String password, String group, String event) {
        this(user, password);
        this._group = group;
        this._event = event;
    }

    public Properties asProperties() {
        Properties p = new Properties();
        p.setProperty(OMERO_USER, this._user);
        p.setProperty(OMERO_PASS, this._pass);
        if (this._group != null) {
            p.setProperty(OMERO_GROUP, this._group);
        }
        if (this._event != null) {
            p.setProperty(OMERO_EVENT, this._event);
        }
        return p;
    }

    public String getName() {
        return this._user;
    }

    public String getPassword() {
        return this._pass;
    }

    public String getGroup() {
        return this._group;
    }

    public String getEvent() {
        return this._event;
    }
}

