/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.codomain;

import omeis.providers.re.codomain.CodomainMap;
import omeis.providers.re.codomain.CodomainMapContext;
import omeis.providers.re.codomain.PlaneSlicingContext;

class PlaneSlicingMap
implements CodomainMap {
    private PlaneSlicingContext psCtx;

    PlaneSlicingMap() {
    }

    private int transformConstant(int x) {
        if (x < this.psCtx.getPlaneSelected()) {
            return this.psCtx.getLowerLimit();
        }
        if (x > this.psCtx.getPlaneSelected() + 1) {
            return this.psCtx.getUpperLimit();
        }
        return this.psCtx.getPlaneSelected();
    }

    private int transformNonConstant(int x) {
        if (x > this.psCtx.getPlanePrevious() && x <= this.psCtx.getPlaneSelected()) {
            return this.psCtx.getPlaneSelected();
        }
        return x;
    }

    @Override
    public void setContext(CodomainMapContext ctx) {
        this.psCtx = (PlaneSlicingContext)ctx;
    }

    @Override
    public int transform(int x) {
        if (this.psCtx.IsConstant()) {
            return this.transformConstant(x);
        }
        return this.transformNonConstant(x);
    }

    public String toString() {
        return "PlaneSlicingMap";
    }
}

