/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.FormatType;
import Ice.InitializationException;
import Ice.Logger;
import Ice.Properties;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Network;
import IceInternal.Protocol;
import java.net.InetSocketAddress;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final InetSocketAddress defaultSourceAddress;
    public final String defaultProtocol;
    public final boolean defaultCollocationOptimization;
    public final EndpointSelectionType defaultEndpointSelection;
    public final int defaultTimeout;
    public final int defaultLocatorCacheTimeout;
    public final int defaultInvocationTimeout;
    public final boolean defaultPreferSecure;
    public final EncodingVersion defaultEncoding;
    public final FormatType defaultFormat;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;
    public final boolean overrideCloseTimeout;
    public final int overrideCloseTimeoutValue;
    public final boolean overrideCompress;
    public final boolean overrideCompressValue;
    public final boolean overrideSecure;
    public final boolean overrideSecureValue;

    DefaultsAndOverrides(Properties properties, Logger logger) {
        StringBuffer msg;
        int intValue;
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String value = properties.getProperty("Ice.Default.Host");
        this.defaultHost = !value.isEmpty() ? value : null;
        value = properties.getProperty("Ice.Default.SourceAddress");
        if (!value.isEmpty()) {
            this.defaultSourceAddress = Network.getNumericAddress(value);
            if (this.defaultSourceAddress == null) {
                throw new InitializationException("invalid IP address set for Ice.Default.SourceAddress: `" + value + "'");
            }
        } else {
            this.defaultSourceAddress = null;
        }
        if (!(value = properties.getProperty("Ice.Override.Timeout")).isEmpty()) {
            this.overrideTimeout = true;
            intValue = properties.getPropertyAsInt("Ice.Override.Timeout");
            if (intValue < 0 && intValue != -1) {
                this.overrideTimeoutValue = -1;
                msg = new StringBuffer("invalid value for Ice.Override.Timeout `");
                msg.append(properties.getProperty("Ice.Override.Timeout"));
                msg.append("': defaulting to -1");
                logger.warning(msg.toString());
            } else {
                this.overrideTimeoutValue = intValue;
            }
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.ConnectTimeout");
        if (!value.isEmpty()) {
            this.overrideConnectTimeout = true;
            intValue = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
            if (intValue < 0 && intValue != -1) {
                this.overrideConnectTimeoutValue = -1;
                msg = new StringBuffer("invalid value for Ice.Override.ConnectTimeout `");
                msg.append(properties.getProperty("Ice.Override.ConnectTimeout"));
                msg.append("': defaulting to -1");
                logger.warning(msg.toString());
            } else {
                this.overrideConnectTimeoutValue = intValue;
            }
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.CloseTimeout");
        if (!value.isEmpty()) {
            this.overrideCloseTimeout = true;
            intValue = properties.getPropertyAsInt("Ice.Override.CloseTimeout");
            if (intValue < 0 && intValue != -1) {
                this.overrideCloseTimeoutValue = -1;
                msg = new StringBuffer("invalid value for Ice.Override.CloseTimeout `");
                msg.append(properties.getProperty("Ice.Override.CloseTimeout"));
                msg.append("': defaulting to -1");
                logger.warning(msg.toString());
            } else {
                this.overrideCloseTimeoutValue = intValue;
            }
        } else {
            this.overrideCloseTimeout = false;
            this.overrideCloseTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.Compress");
        if (!value.isEmpty()) {
            boolean b;
            this.overrideCompress = true;
            boolean bl = b = properties.getPropertyAsInt("Ice.Override.Compress") > 0;
            if (b && !BasicStream.compressible()) {
                System.err.println("warning: bzip2 support not available, Ice.Override.Compress ignored");
                b = false;
            }
            this.overrideCompressValue = b;
        } else {
            this.overrideCompress = false;
            this.overrideCompressValue = false;
        }
        value = properties.getProperty("Ice.Override.Secure");
        if (!value.isEmpty()) {
            this.overrideSecure = true;
            this.overrideSecureValue = properties.getPropertyAsInt("Ice.Override.Secure") > 0;
        } else {
            this.overrideSecure = false;
            this.overrideSecureValue = false;
        }
        this.defaultCollocationOptimization = properties.getPropertyAsIntWithDefault("Ice.Default.CollocationOptimized", 1) > 0;
        value = properties.getPropertyWithDefault("Ice.Default.EndpointSelection", "Random");
        if (value.equals("Random")) {
            this.defaultEndpointSelection = EndpointSelectionType.Random;
        } else if (value.equals("Ordered")) {
            this.defaultEndpointSelection = EndpointSelectionType.Ordered;
        } else {
            EndpointSelectionTypeParseException ex = new EndpointSelectionTypeParseException();
            ex.str = "illegal value `" + value + "'; expected `Random' or `Ordered'";
            throw ex;
        }
        intValue = properties.getPropertyAsIntWithDefault("Ice.Default.Timeout", 60000);
        if (intValue < 1 && intValue != -1) {
            this.defaultTimeout = 60000;
            StringBuffer msg2 = new StringBuffer("invalid value for Ice.Default.Timeout `");
            msg2.append(properties.getProperty("Ice.Default.Timeout"));
            msg2.append("': defaulting to 60000");
            logger.warning(msg2.toString());
        } else {
            this.defaultTimeout = intValue;
        }
        intValue = properties.getPropertyAsIntWithDefault("Ice.Default.LocatorCacheTimeout", -1);
        if (intValue < -1) {
            this.defaultLocatorCacheTimeout = -1;
            StringBuffer msg3 = new StringBuffer("invalid value for Ice.Default.LocatorCacheTimeout `");
            msg3.append(properties.getProperty("Ice.Default.LocatorCacheTimeout"));
            msg3.append("': defaulting to -1");
            logger.warning(msg3.toString());
        } else {
            this.defaultLocatorCacheTimeout = intValue;
        }
        intValue = properties.getPropertyAsIntWithDefault("Ice.Default.InvocationTimeout", -1);
        if (intValue < 1 && intValue != -1 && intValue != -2) {
            this.defaultInvocationTimeout = -1;
            StringBuffer msg4 = new StringBuffer("invalid value for Ice.Default.InvocationTimeout `");
            msg4.append(properties.getProperty("Ice.Default.InvocationTimeout"));
            msg4.append("': defaulting to -1");
            logger.warning(msg4.toString());
        } else {
            this.defaultInvocationTimeout = intValue;
        }
        this.defaultPreferSecure = properties.getPropertyAsIntWithDefault("Ice.Default.PreferSecure", 0) > 0;
        value = properties.getPropertyWithDefault("Ice.Default.EncodingVersion", Util.encodingVersionToString(Protocol.currentEncoding));
        this.defaultEncoding = Util.stringToEncodingVersion(value);
        Protocol.checkSupportedEncoding(this.defaultEncoding);
        boolean slicedFormat = properties.getPropertyAsIntWithDefault("Ice.Default.SlicedFormat", 0) > 0;
        this.defaultFormat = slicedFormat ? FormatType.SlicedFormat : FormatType.CompactFormat;
    }
}

