/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.ConnectionInfo;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.Exception;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.IPConnectionInfo;
import Ice.Identity;
import Ice.Instrumentation.DispatchObserver;
import Ice.LocalException;
import Ice.LocalObjectHolder;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.ServantLocator;
import Ice.SystemException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.Protocol;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceUtilInternal.OutputBase;
import IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

class IncomingBase {
    protected Instance _instance;
    protected Current _current;
    protected Object _servant;
    protected ServantLocator _locator;
    protected LocalObjectHolder _cookie;
    protected DispatchObserver _observer;
    protected boolean _response;
    protected byte _compress;
    protected BasicStream _os;
    protected ResponseHandler _responseHandler;
    protected LinkedList<DispatchInterceptorAsyncCallback> _interceptorAsyncCallbackList;

    protected IncomingBase(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._responseHandler = handler;
        this._response = response;
        this._compress = compress;
        if (this._response) {
            this._os = new BasicStream(instance, Protocol.currentProtocolEncoding);
        }
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        this._cookie = new LocalObjectHolder();
    }

    protected IncomingBase(IncomingBase in) {
        this._current = in._current;
        if (in._interceptorAsyncCallbackList != null) {
            this._interceptorAsyncCallbackList = new LinkedList<DispatchInterceptorAsyncCallback>(in._interceptorAsyncCallbackList);
        }
        this.adopt(in);
    }

    protected void adopt(IncomingBase other) {
        this._instance = other._instance;
        this._observer = other._observer;
        other._observer = null;
        this._servant = other._servant;
        other._servant = null;
        this._locator = other._locator;
        other._locator = null;
        this._cookie = other._cookie;
        other._cookie = null;
        this._response = other._response;
        other._response = false;
        this._compress = other._compress;
        other._compress = 0;
        this._os = other._os;
        other._os = null;
        this._responseHandler = other._responseHandler;
        other._responseHandler = null;
    }

    public BasicStream __startWriteParams(FormatType format) {
        if (!this._response) {
            throw new MarshalException("can't marshal out parameters for oneway dispatch");
        }
        assert (this._os.size() == 18);
        assert (this._current.encoding != null);
        this._os.writeByte((byte)0);
        this._os.startWriteEncaps(this._current.encoding, format);
        return this._os;
    }

    public void __endWriteParams(boolean ok) {
        if (!ok && this._observer != null) {
            this._observer.userException();
        }
        assert (this._response);
        int save = this._os.pos();
        this._os.pos(18);
        this._os.writeByte(ok ? (byte)0 : 1);
        this._os.pos(save);
        this._os.endWriteEncaps();
    }

    public void __writeEmptyParams() {
        if (this._response) {
            assert (this._os.size() == 18);
            assert (this._current.encoding != null);
            this._os.writeByte((byte)0);
            this._os.writeEmptyEncaps(this._current.encoding);
        }
    }

    public void __writeParamEncaps(byte[] v, boolean ok) {
        if (!ok && this._observer != null) {
            this._observer.userException();
        }
        if (this._response) {
            assert (this._os.size() == 18);
            assert (this._current.encoding != null);
            this._os.writeByte(ok ? (byte)0 : 1);
            if (v == null || v.length == 0) {
                this._os.writeEmptyEncaps(this._current.encoding);
            } else {
                this._os.writeEncaps(v);
            }
        }
    }

    public void __writeUserException(UserException ex, FormatType format) {
        BasicStream __os = this.__startWriteParams(format);
        __os.writeUserException(ex);
        this.__endWriteParams(false);
    }

    public void reset(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        if (this._cookie == null) {
            this._cookie = new LocalObjectHolder();
        }
        this._response = response;
        this._compress = compress;
        if (this._response && this._os == null) {
            this._os = new BasicStream(instance, Protocol.currentProtocolEncoding);
        }
        this._responseHandler = handler;
        this._interceptorAsyncCallbackList = null;
    }

    public void reclaim() {
        this._servant = null;
        this._locator = null;
        if (this._cookie != null) {
            this._cookie.value = null;
        }
        this._observer = null;
        if (this._os != null) {
            this._os.reset();
        }
        this._interceptorAsyncCallbackList = null;
    }

    protected final void __warning(java.lang.Exception ex) {
        assert (this._instance != null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OutputBase out = new OutputBase(pw);
        out.setUseTab(false);
        out.print("dispatch exception:");
        out.print("\nidentity: " + this._instance.identityToString(this._current.id));
        out.print("\nfacet: " + StringUtil.escapeString(this._current.facet, ""));
        out.print("\noperation: " + this._current.operation);
        if (this._current.con != null) {
            try {
                ConnectionInfo connInfo = this._current.con.getInfo();
                if (connInfo instanceof IPConnectionInfo) {
                    IPConnectionInfo ipConnInfo = (IPConnectionInfo)connInfo;
                    out.print("\nremote host: " + ipConnInfo.remoteAddress + " remote port: " + Integer.toString(ipConnInfo.remotePort));
                }
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        out.print("\n");
        ex.printStackTrace(pw);
        pw.flush();
        this._instance.initializationData().logger.warning(sw.toString());
    }

    protected final boolean __servantLocatorFinished(boolean amd) {
        assert (this._locator != null && this._servant != null);
        try {
            this._locator.finished(this._current, this._servant, this._cookie.value);
            return true;
        }
        catch (UserException ex) {
            assert (this._responseHandler != null);
            if (this._observer != null) {
                this._observer.userException();
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)1);
                this._os.startWriteEncaps(this._current.encoding, FormatType.DefaultFormat);
                this._os.writeUserException(ex);
                this._os.endWriteEncaps();
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
            if (this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this._responseHandler = null;
        }
        catch (java.lang.Exception ex) {
            this.__handleException(ex, amd);
        }
        catch (Error ex) {
            this.__handleError(ex, amd);
        }
        return false;
    }

    protected final void __handleException(java.lang.Exception exc, boolean amd) {
        assert (this._responseHandler != null);
        try {
            throw exc;
        }
        catch (RequestFailedException ex) {
            if (ex.id == null || ex.id.name == null || ex.id.name.isEmpty()) {
                ex.id = this._current.id;
            }
            if (ex.facet == null || ex.facet.isEmpty()) {
                ex.facet = this._current.facet;
            }
            if (ex.operation == null || ex.operation.length() == 0) {
                ex.operation = this._current.operation;
            }
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                if (ex instanceof ObjectNotExistException) {
                    this._os.writeByte((byte)2);
                } else if (ex instanceof FacetNotExistException) {
                    this._os.writeByte((byte)3);
                } else if (ex instanceof OperationNotExistException) {
                    this._os.writeByte((byte)4);
                } else assert (false);
                ex.id.__write(this._os);
                if (ex.facet == null || ex.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] facetPath2 = new String[]{ex.facet};
                    this._os.writeStringSeq(facetPath2);
                }
                this._os.writeString(ex.operation);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownLocalException ex) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                this._os.writeString(ex.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownUserException ex) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                this._os.writeString(ex.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownException ex) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                this._os.writeString(ex.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (Exception ex) {
            if (ex instanceof SystemException && this._responseHandler.systemException(this._current.requestId, (SystemException)ex, amd)) {
                return;
            }
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                StringWriter sw = new StringWriter();
                sw.write(ex.ice_name() + "\n");
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UserException ex) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                StringWriter sw = new StringWriter();
                sw.write(ex.ice_name() + "\n");
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (java.lang.Exception ex) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._observer != null) {
                this._observer.failed(ex.getClass().getName());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            }
            this._responseHandler.sendNoResponse();
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }

    protected final void __handleError(Error exc, boolean amd) {
        assert (this._responseHandler != null);
        UnknownException uex = new UnknownException(exc);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exc.printStackTrace(pw);
        pw.flush();
        uex.unknown = sw.toString();
        if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
            this.__warning(uex);
        }
        if (this._observer != null) {
            this._observer.failed(uex.ice_name());
        }
        if (this._response) {
            this._os.resize(18, false);
            this._os.writeByte((byte)7);
            this._os.writeString(uex.unknown);
            if (this._observer != null) {
                this._observer.reply(this._os.size() - 14 - 4);
            }
            this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
        } else {
            this._responseHandler.sendNoResponse();
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
        throw new ServantError(exc);
    }
}

