/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.SyscallException;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Time;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Selector {
    private final Instance _instance;
    private java.nio.channels.Selector _selector;
    private Set<SelectionKey> _keys;
    private HashSet<EventHandler> _changes = new HashSet();
    private boolean _selecting;
    private boolean _interrupted;
    private int _spuriousWakeUp;

    Selector(Instance instance) {
        this._instance = instance;
        this._selecting = false;
        this._interrupted = false;
        try {
            this._selector = java.nio.channels.Selector.open();
        }
        catch (IOException ex) {
            throw new SyscallException(ex);
        }
        this._keys = this._selector.selectedKeys();
    }

    void destroy() {
        try {
            this._selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._selector = null;
    }

    void initialize(EventHandler handler) {
        this.updateImpl(handler);
    }

    void update(EventHandler handler, int remove, int add) {
        int previous = handler._registered;
        handler._registered &= ~remove;
        handler._registered |= add;
        if (previous == handler._registered) {
            return;
        }
        this.updateImpl(handler);
    }

    void enable(EventHandler handler, int status) {
        if ((handler._disabled & status) == 0) {
            return;
        }
        handler._disabled &= ~status;
        if (handler._key != null && (handler._registered & status) != 0) {
            this.updateImpl(handler);
        }
    }

    void disable(EventHandler handler, int status) {
        if ((handler._disabled & status) != 0) {
            return;
        }
        handler._disabled |= status;
        if (handler._key != null && (handler._registered & status) != 0) {
            this.updateImpl(handler);
        }
    }

    boolean finish(EventHandler handler, boolean closeNow) {
        handler._registered = 0;
        if (handler._key != null) {
            handler._key.cancel();
            handler._key = null;
        }
        this._changes.remove(handler);
        return closeNow;
    }

    void startSelect() {
        if (!this._changes.isEmpty()) {
            this.updateSelector();
        }
        this._selecting = true;
    }

    void finishSelect(List<EventHandlerOpPair> handlers) {
        assert (handlers.isEmpty());
        if (this._keys.isEmpty() && !this._interrupted) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++this._spuriousWakeUp > 100) {
                this._spuriousWakeUp = 0;
                this._instance.initializationData().logger.warning("spurious selector wake up");
            }
            return;
        }
        this._interrupted = false;
        this._spuriousWakeUp = 0;
        for (SelectionKey key : this._keys) {
            EventHandler handler = (EventHandler)key.attachment();
            try {
                int op = this.fromJavaOps(key.readyOps() & key.interestOps());
                handlers.add(new EventHandlerOpPair(handler, op));
            }
            catch (CancelledKeyException ex) {
                assert (handler._registered == 0);
            }
        }
        this._keys.clear();
        this._selecting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void select(long timeout) throws TimeoutException {
        while (true) {
            try {
                if (timeout > 0L) {
                    before = Time.currentMonotonicTimeMillis();
                    if (this._selector.select(timeout * 1000L + 10L) != 0 || Time.currentMonotonicTimeMillis() - before < timeout * 1000L) break;
                    throw new TimeoutException();
                }
                this._selector.select();
            }
            catch (CancelledKeyException ex) {
                continue;
            }
            catch (IOException ex) {
                if (!Network.interrupted(ex)) ** break;
                continue;
                try {
                    s = "fatal error: selector failed:\n" + ex.getCause().getMessage();
                    this._instance.initializationData().logger.error(s);
                }
                finally {
                    Runtime.getRuntime().halt(1);
                }
            }
            break;
        }
    }

    void wakeup() {
        this._selector.wakeup();
        this._interrupted = true;
    }

    private void updateImpl(EventHandler handler) {
        this._changes.add(handler);
        if (this._selecting) {
            this.wakeup();
        } else {
            this.updateSelector();
        }
    }

    private void updateSelector() {
        for (EventHandler handler : this._changes) {
            int status = handler._registered & ~handler._disabled;
            int ops = this.toJavaOps(handler, status);
            if (handler._key == null) {
                if (handler._registered == 0) continue;
                try {
                    handler._key = handler.fd().register(this._selector, ops, handler);
                    continue;
                }
                catch (ClosedChannelException ex) {
                    assert (false);
                    continue;
                }
            }
            handler._key.interestOps(ops);
        }
        this._changes.clear();
    }

    private int toJavaOps(EventHandler handler, int o) {
        int op = 0;
        if ((o & 1) != 0) {
            op = (handler.fd().validOps() & 1) != 0 ? (op |= 1) : (op |= 0x10);
        }
        if ((o & 4) != 0) {
            op |= 4;
        }
        if ((o & 8) != 0) {
            op |= 8;
        }
        return op;
    }

    private int fromJavaOps(int o) {
        int op = 0;
        if ((o & 0x11) != 0) {
            op |= 1;
        }
        if ((o & 4) != 0) {
            op |= 4;
        }
        if ((o & 8) != 0) {
            op |= 8;
        }
        return op;
    }

    static final class TimeoutException
    extends Exception {
        TimeoutException() {
        }
    }
}

