/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.Dispatcher;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.OperationInterruptedException;
import Ice.Properties;
import IceInternal.DispatchWorkItem;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Ex;
import IceInternal.Instance;
import IceInternal.Selector;
import IceInternal.ThreadPoolCurrent;
import IceInternal.ThreadPoolWorkItem;
import IceInternal.ThreadPoolWorkQueue;
import IceInternal.Time;
import IceInternal.Util;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class ThreadPool {
    private static ThreadPoolWorkItem _interruptWorkItem = new InterruptWorkItem();
    private final Instance _instance;
    private final Dispatcher _dispatcher;
    private final ThreadPoolWorkQueue _workQueue;
    private boolean _destroyed;
    private final String _prefix;
    private final String _threadPrefix;
    private final Selector _selector;
    private final int _size;
    private final int _sizeIO;
    private final int _sizeMax;
    private final int _sizeWarn;
    private final boolean _serialize;
    private final int _priority;
    private final boolean _hasPriority;
    private final long _serverIdleTime;
    private final long _threadIdleTime;
    private final int _stackSize;
    private List<EventHandlerThread> _threads = new ArrayList<EventHandlerThread>();
    private int _threadIndex;
    private int _inUse;
    private int _inUseIO;
    private List<EventHandlerOpPair> _handlers = new ArrayList<EventHandlerOpPair>();
    private Iterator<EventHandlerOpPair> _nextHandler;
    private HashSet<EventHandler> _pendingHandlers = new HashSet();
    private boolean _promote;

    public ThreadPool(Instance instance, String prefix, int timeout) {
        String s;
        int sizeWarn;
        int sizeMax;
        Properties properties = instance.initializationData().properties;
        this._instance = instance;
        this._dispatcher = instance.initializationData().dispatcher;
        this._destroyed = false;
        this._prefix = prefix;
        this._selector = new Selector(instance);
        this._threadIndex = 0;
        this._inUse = 0;
        this._inUseIO = 0;
        this._promote = true;
        this._serialize = properties.getPropertyAsInt(this._prefix + ".Serialize") > 0;
        this._serverIdleTime = timeout;
        this._threadPrefix = Util.createThreadName(properties, this._prefix);
        int nProcessors = Runtime.getRuntime().availableProcessors();
        int size = properties.getPropertyAsIntWithDefault(this._prefix + ".Size", 1);
        if (size < 1) {
            String s2 = this._prefix + ".Size < 1; Size adjusted to 1";
            this._instance.initializationData().logger.warning(s2);
            size = 1;
        }
        if ((sizeMax = properties.getPropertyAsIntWithDefault(this._prefix + ".SizeMax", size)) == -1) {
            sizeMax = nProcessors;
        }
        if (sizeMax < size) {
            String s3 = this._prefix + ".SizeMax < " + this._prefix + ".Size; SizeMax adjusted to Size (" + size + ")";
            this._instance.initializationData().logger.warning(s3);
            sizeMax = size;
        }
        if ((sizeWarn = properties.getPropertyAsInt(this._prefix + ".SizeWarn")) != 0 && sizeWarn < size) {
            s = this._prefix + ".SizeWarn < " + this._prefix + ".Size; adjusted SizeWarn to Size (" + size + ")";
            this._instance.initializationData().logger.warning(s);
            sizeWarn = size;
        } else if (sizeWarn > sizeMax) {
            s = this._prefix + ".SizeWarn > " + this._prefix + ".SizeMax; adjusted SizeWarn to SizeMax (" + sizeMax + ")";
            this._instance.initializationData().logger.warning(s);
            sizeWarn = sizeMax;
        }
        int threadIdleTime = properties.getPropertyAsIntWithDefault(this._prefix + ".ThreadIdleTime", 60);
        if (threadIdleTime < 0) {
            String s4 = this._prefix + ".ThreadIdleTime < 0; ThreadIdleTime adjusted to 0";
            this._instance.initializationData().logger.warning(s4);
            threadIdleTime = 0;
        }
        this._size = size;
        this._sizeMax = sizeMax;
        this._sizeWarn = sizeWarn;
        this._sizeIO = Math.min(sizeMax, nProcessors);
        this._threadIdleTime = threadIdleTime;
        int stackSize = properties.getPropertyAsInt(this._prefix + ".StackSize");
        if (stackSize < 0) {
            String s5 = this._prefix + ".StackSize < 0; Size adjusted to JRE default";
            this._instance.initializationData().logger.warning(s5);
            stackSize = 0;
        }
        this._stackSize = stackSize;
        boolean hasPriority = properties.getProperty(this._prefix + ".ThreadPriority").length() > 0;
        int priority = properties.getPropertyAsInt(this._prefix + ".ThreadPriority");
        if (!hasPriority) {
            hasPriority = properties.getProperty("Ice.ThreadPriority").length() > 0;
            priority = properties.getPropertyAsInt("Ice.ThreadPriority");
        }
        this._hasPriority = hasPriority;
        this._priority = priority;
        this._workQueue = new ThreadPoolWorkQueue(this._instance, this, this._selector);
        this._nextHandler = this._handlers.iterator();
        if (this._instance.traceLevels().threadPool >= 1) {
            String s6 = "creating " + this._prefix + ": Size = " + this._size + ", SizeMax = " + this._sizeMax + ", SizeWarn = " + this._sizeWarn;
            this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s6);
        }
        try {
            for (int i = 0; i < this._size; ++i) {
                EventHandlerThread thread = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                if (this._hasPriority) {
                    thread.start(this._priority);
                } else {
                    thread.start(5);
                }
                this._threads.add(thread);
            }
        }
        catch (RuntimeException ex) {
            String s7 = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(ex);
            this._instance.initializationData().logger.error(s7);
            this.destroy();
            try {
                this.joinWithAllThreads();
            }
            catch (InterruptedException e) {
                throw new OperationInterruptedException();
            }
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        this._workQueue.destroy();
    }

    public synchronized void updateObservers() {
        for (EventHandlerThread thread : this._threads) {
            thread.updateObserver();
        }
    }

    public synchronized void initialize(EventHandler handler) {
        assert (!this._destroyed);
        this._selector.initialize(handler);
    }

    public void register(EventHandler handler, int op) {
        this.update(handler, 0, op);
    }

    public synchronized void update(EventHandler handler, int remove, int add) {
        assert (!this._destroyed);
        remove &= ~add;
        if ((remove = handler._registered & remove) == (add = ~handler._registered & add)) {
            return;
        }
        this._selector.update(handler, remove, add);
        if ((add & 1) != 0 && ((Boolean)handler._hasMoreData.value).booleanValue() && (handler._disabled & 1) == 0) {
            if (this._pendingHandlers.isEmpty()) {
                this._workQueue.queue(_interruptWorkItem);
            }
            this._pendingHandlers.add(handler);
        } else if ((remove & 1) != 0) {
            this._pendingHandlers.remove(handler);
        }
    }

    public void unregister(EventHandler handler, int op) {
        this.update(handler, op, 0);
    }

    public synchronized boolean finish(EventHandler handler, boolean closeNow) {
        assert (!this._destroyed);
        closeNow = this._selector.finish(handler, closeNow);
        this._pendingHandlers.remove(handler);
        this._workQueue.queue(new FinishedWorkItem(handler, !closeNow));
        return closeNow;
    }

    public void dispatchFromThisThread(DispatchWorkItem workItem) {
        if (this._dispatcher != null) {
            try {
                this._dispatcher.dispatch(workItem, workItem.getConnection());
            }
            catch (Exception ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._instance.initializationData().logger.warning("dispatch exception:\n" + sw.toString());
                }
            }
        } else {
            workItem.run();
        }
    }

    public void dispatch(DispatchWorkItem workItem) {
        this._workQueue.queue(workItem);
    }

    public void joinWithAllThreads() throws InterruptedException {
        for (EventHandlerThread thread : this._threads) {
            thread.join();
        }
        this._selector.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(EventHandlerThread thread) {
        ThreadPoolCurrent current = new ThreadPoolCurrent(this._instance, this, thread);
        boolean select = false;
        while (true) {
            Iterator<Object> s;
            if (current._handler != null) {
                try {
                    current._handler.message(current);
                }
                catch (DestroyedException ex) {
                    return;
                }
                catch (Exception ex) {
                    s = "exception in `" + this._prefix + "':\n" + Ex.toString(ex);
                    s = (String)((Object)s) + "\nevent handler: " + current._handler.toString();
                    this._instance.initializationData().logger.error((String)((Object)s));
                }
            } else if (select && this._workQueue.size() == 0) {
                try {
                    this._selector.select(this._serverIdleTime);
                }
                catch (Selector.TimeoutException ex) {
                    s = this;
                    synchronized (s) {
                        if (!this._destroyed && this._inUse == 0) {
                            this._workQueue.queue(new ShutdownWorkItem());
                        }
                        continue;
                    }
                }
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (current._handler == null) {
                    if (select) {
                        this._selector.finishSelect(this._handlers);
                        this._workQueue.update(this._handlers);
                        select = false;
                        if (!this._pendingHandlers.isEmpty()) {
                            for (EventHandlerOpPair pair : this._handlers) {
                                this._pendingHandlers.remove(pair.handler);
                            }
                            for (EventHandler p : this._pendingHandlers) {
                                this._handlers.add(new EventHandlerOpPair(p, 1));
                            }
                            this._pendingHandlers.clear();
                        }
                        this._nextHandler = this._handlers.iterator();
                    } else if (!current._leader && this.followerWait(current)) {
                        return;
                    }
                } else if (this._sizeMax > 1) {
                    if (!current._ioCompleted) {
                        --this._inUseIO;
                        if (((Boolean)current._handler._hasMoreData.value).booleanValue() && (current._handler._registered & 1) != 0) {
                            if (this._pendingHandlers.isEmpty()) {
                                this._workQueue.queue(_interruptWorkItem);
                            }
                            this._pendingHandlers.add(current._handler);
                        }
                    } else {
                        if (this._serialize) {
                            this._selector.enable(current._handler, current.operation);
                            if (((Boolean)current._handler._hasMoreData.value).booleanValue() && (current._handler._registered & 1) != 0) {
                                if (this._pendingHandlers.isEmpty()) {
                                    this._workQueue.queue(_interruptWorkItem);
                                }
                                this._pendingHandlers.add(current._handler);
                            }
                        }
                        assert (this._inUse > 0);
                        --this._inUse;
                    }
                    if (!current._leader && this.followerWait(current)) {
                        return;
                    }
                } else if (((Boolean)current._handler._hasMoreData.value).booleanValue() && (current._handler._registered & 1) != 0) {
                    if (this._pendingHandlers.isEmpty()) {
                        this._workQueue.queue(_interruptWorkItem);
                    }
                    this._pendingHandlers.add(current._handler);
                }
                EventHandlerOpPair next = null;
                while (this._nextHandler.hasNext()) {
                    EventHandlerOpPair n = this._nextHandler.next();
                    if ((n.op & n.handler._registered) == 0) continue;
                    next = n;
                    break;
                }
                if (next != null) {
                    current._ioCompleted = false;
                    current._handler = next.handler;
                    current.operation = next.op;
                    thread.setState(ThreadState.ThreadStateInUseForIO);
                } else {
                    current._handler = null;
                }
                if (current._handler == null) {
                    if (this._inUseIO > 0) {
                        this.promoteFollower(current);
                    } else {
                        this._handlers.clear();
                        this._selector.startSelect();
                        select = true;
                        thread.setState(ThreadState.ThreadStateIdle);
                    }
                } else if (this._sizeMax > 1) {
                    ++this._inUseIO;
                    if (this._nextHandler.hasNext() && this._inUseIO < this._sizeIO) {
                        this.promoteFollower(current);
                    }
                }
            }
        }
    }

    synchronized void ioCompleted(ThreadPoolCurrent current) {
        current._ioCompleted = true;
        current._thread.setState(ThreadState.ThreadStateInUseForUser);
        if (this._sizeMax > 1) {
            String s;
            --this._inUseIO;
            if (!this._destroyed) {
                if (this._serialize) {
                    this._selector.disable(current._handler, current.operation);
                    this._pendingHandlers.remove(current._handler);
                } else if (((Boolean)current._handler._hasMoreData.value).booleanValue() && (current._handler._registered & 1) != 0) {
                    if (this._pendingHandlers.isEmpty()) {
                        this._workQueue.queue(_interruptWorkItem);
                    }
                    this._pendingHandlers.add(current._handler);
                }
            }
            if (current._leader) {
                this.promoteFollower(current);
            } else if (this._promote && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
                this.notify();
            }
            assert (this._inUse >= 0);
            ++this._inUse;
            if (this._inUse == this._sizeWarn) {
                s = "thread pool `" + this._prefix + "' is running low on threads\nSize=" + this._size + ", SizeMax=" + this._sizeMax + ", SizeWarn=" + this._sizeWarn;
                this._instance.initializationData().logger.warning(s);
            }
            if (!this._destroyed) {
                assert (this._inUse <= this._threads.size());
                if (this._inUse < this._sizeMax && this._inUse == this._threads.size()) {
                    if (this._instance.traceLevels().threadPool >= 1) {
                        s = "growing " + this._prefix + ": Size=" + (this._threads.size() + 1);
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s);
                    }
                    try {
                        EventHandlerThread thread = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                        this._threads.add(thread);
                        if (this._hasPriority) {
                            thread.start(this._priority);
                        } else {
                            thread.start(5);
                        }
                    }
                    catch (RuntimeException ex) {
                        String s2 = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(ex);
                        this._instance.initializationData().logger.error(s2);
                    }
                }
            }
        }
    }

    private synchronized void promoteFollower(ThreadPoolCurrent current) {
        assert (!this._promote && current._leader);
        this._promote = true;
        if (this._inUseIO < this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
            this.notify();
        }
        current._leader = false;
    }

    private synchronized boolean followerWait(ThreadPoolCurrent current) {
        assert (!current._leader);
        current._thread.setState(ThreadState.ThreadStateIdle);
        current._handler = null;
        current.stream.reset();
        while (!this._promote || this._inUseIO == this._sizeIO || !this._nextHandler.hasNext() && this._inUseIO > 0) {
            if (this._threadIdleTime > 0L) {
                long before = Time.currentMonotonicTimeMillis();
                boolean interrupted = false;
                try {
                    this.wait(this._threadIdleTime * 1000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!interrupted && Time.currentMonotonicTimeMillis() - before < this._threadIdleTime * 1000L || this._destroyed || this._promote && this._inUseIO != this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO <= 0)) continue;
                if (this._instance.traceLevels().threadPool >= 1) {
                    String s = "shrinking " + this._prefix + ": Size=" + (this._threads.size() - 1);
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s);
                }
                assert (this._threads.size() > 1);
                this._threads.remove(current._thread);
                this._workQueue.queue(new JoinThreadWorkItem(current._thread));
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        current._leader = true;
        this._promote = false;
        return false;
    }

    final class EventHandlerThread
    implements Runnable {
        private final String _name;
        private Thread _thread;
        private ThreadState _state;
        private ThreadObserver _observer;

        EventHandlerThread(String name) {
            this._name = name;
            this._state = ThreadState.ThreadStateIdle;
            this.updateObserver();
        }

        public void updateObserver() {
            CommunicatorObserver obsv = ((ThreadPool)ThreadPool.this)._instance.initializationData().observer;
            if (obsv != null) {
                this._observer = obsv.getThreadObserver(ThreadPool.this._prefix, this._name, this._state, this._observer);
                if (this._observer != null) {
                    this._observer.attach();
                }
            }
        }

        public void setState(ThreadState s) {
            if (this._observer != null && this._state != s) {
                this._observer.stateChanged(this._state, s);
            }
            this._state = s;
        }

        public void join() throws InterruptedException {
            this._thread.join();
        }

        public void start(int priority) {
            this._thread = new Thread(null, this, this._name, ThreadPool.this._stackSize);
            this._thread.setPriority(priority);
            this._thread.start();
        }

        @Override
        public void run() {
            String s;
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.start();
                }
                catch (Exception ex) {
                    s = "thread hook start() method raised an unexpected exception in `";
                    s = s + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
                }
            }
            try {
                ThreadPool.this.run(this);
            }
            catch (Exception ex) {
                s = "exception in `" + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
            }
            if (this._observer != null) {
                this._observer.detach();
            }
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.stop();
                }
                catch (Exception ex) {
                    s = "thread hook stop() method raised an unexpected exception in `";
                    s = s + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
                }
            }
        }
    }

    static final class DestroyedException
    extends RuntimeException {
        DestroyedException() {
        }
    }

    static final class InterruptWorkItem
    implements ThreadPoolWorkItem {
        InterruptWorkItem() {
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
        }
    }

    static final class JoinThreadWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandlerThread _thread;

        public JoinThreadWorkItem(EventHandlerThread thread) {
            this._thread = thread;
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static final class FinishedWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandler _handler;
        private final boolean _close;

        public FinishedWorkItem(EventHandler handler, boolean close) {
            this._handler = handler;
            this._close = close;
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            this._handler.finished(current, this._close);
        }
    }

    final class ShutdownWorkItem
    implements ThreadPoolWorkItem {
        ShutdownWorkItem() {
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            current.ioCompleted();
            try {
                ThreadPool.this._instance.objectAdapterFactory().shutdown();
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
                // empty catch block
            }
        }
    }
}

