/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.adobe.AdobeJpegReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jfif.JfifReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.xmp.XmpReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class JpegMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException {
        return JpegMetadataReader.readMetadata(inputStream, true);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, boolean waitForBytes) throws JpegProcessingException {
        JpegSegmentReader segmentReader = new JpegSegmentReader(inputStream, waitForBytes);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(segmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        JpegSegmentReader segmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(segmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata extractMetadataFromJpegSegmentReader(@NotNull JpegSegmentData segmentReader) {
        byte[] comSegment;
        Metadata metadata = new Metadata();
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            byte[] jpegSegment;
            if (i == 4 || i == 12 || (jpegSegment = segmentReader.getSegment((byte)(-64 + i))) == null) continue;
            JpegDirectory directory = metadata.getOrCreateDirectory(JpegDirectory.class);
            directory.setInt(-3, i);
            new JpegReader().extract(new ByteArrayReader(jpegSegment), metadata);
            break;
        }
        if ((comSegment = segmentReader.getSegment((byte)-2)) != null) {
            new JpegCommentReader().extract(new ByteArrayReader(comSegment), metadata);
        }
        for (byte[] app0Segment : segmentReader.getSegments((byte)-32)) {
            if (app0Segment.length <= 3 || !new String(app0Segment, 0, 4).equals("JFIF")) continue;
            new JfifReader().extract(new ByteArrayReader(app0Segment), metadata);
        }
        for (byte[] app1Segment : segmentReader.getSegments((byte)-31)) {
            if (app1Segment.length > 3 && "EXIF".equalsIgnoreCase(new String(app1Segment, 0, 4))) {
                new ExifReader().extract(new ByteArrayReader(app1Segment), metadata);
            }
            if (app1Segment.length <= 27 || !"http://ns.adobe.com/xap/1.0/".equalsIgnoreCase(new String(app1Segment, 0, 28))) continue;
            new XmpReader().extract(new ByteArrayReader(app1Segment), metadata);
        }
        for (byte[] app2Segment : segmentReader.getSegments((byte)-30)) {
            if (app2Segment.length <= 10 || !new String(app2Segment, 0, 11).equalsIgnoreCase("ICC_PROFILE")) continue;
            byte[] icc = new byte[app2Segment.length - 14];
            System.arraycopy(app2Segment, 14, icc, 0, app2Segment.length - 14);
            new IccReader().extract(new ByteArrayReader(icc), metadata);
        }
        for (byte[] appdSegment : segmentReader.getSegments((byte)-19)) {
            if (appdSegment.length > 12 && "Photoshop 3.0".compareTo(new String(appdSegment, 0, 13)) == 0) {
                new PhotoshopReader().extract(new ByteArrayReader(appdSegment), metadata);
                continue;
            }
            new IptcReader().extract(new ByteArrayReader(appdSegment), metadata);
        }
        for (byte[] appeSegment : segmentReader.getSegments((byte)-18)) {
            if (appeSegment.length != 12 || "Adobe".compareTo(new String(appeSegment, 0, 5)) != 0) continue;
            new AdobeJpegReader().extract(new ByteArrayReader(appeSegment), metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

