/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPMeta;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.xmp.XmpDescriptor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpDirectory
extends Directory {
    public static final int TAG_MAKE = 1;
    public static final int TAG_MODEL = 2;
    public static final int TAG_EXPOSURE_TIME = 3;
    public static final int TAG_SHUTTER_SPEED = 4;
    public static final int TAG_F_NUMBER = 5;
    public static final int TAG_LENS_INFO = 6;
    public static final int TAG_LENS = 7;
    public static final int TAG_CAMERA_SERIAL_NUMBER = 8;
    public static final int TAG_FIRMWARE = 9;
    public static final int TAG_FOCAL_LENGTH = 10;
    public static final int TAG_APERTURE_VALUE = 11;
    public static final int TAG_EXPOSURE_PROGRAM = 12;
    public static final int TAG_DATETIME_ORIGINAL = 13;
    public static final int TAG_DATETIME_DIGITIZED = 14;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();
    @NotNull
    private final Map<String, String> _propertyValueByPath = new HashMap<String, String>();
    @Nullable
    private XMPMeta _xmpMeta;

    public XmpDirectory() {
        this.setDescriptor(new XmpDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Xmp";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    void addProperty(@NotNull String path, @NotNull String value) {
        this._propertyValueByPath.put(path, value);
    }

    @NotNull
    public Map<String, String> getXmpProperties() {
        return this._propertyValueByPath;
    }

    public void setXMPMeta(@NotNull XMPMeta xmpMeta) {
        this._xmpMeta = xmpMeta;
    }

    @Nullable
    public XMPMeta getXMPMeta() {
        return this._xmpMeta;
    }

    static {
        _tagNameMap.put(1, "Make");
        _tagNameMap.put(2, "Model");
        _tagNameMap.put(3, "Exposure Time");
        _tagNameMap.put(4, "Shutter Speed Value");
        _tagNameMap.put(5, "F-Number");
        _tagNameMap.put(6, "Lens Information");
        _tagNameMap.put(7, "Lens");
        _tagNameMap.put(8, "Serial Number");
        _tagNameMap.put(9, "Firmware");
        _tagNameMap.put(10, "Focal Length");
        _tagNameMap.put(11, "Aperture Value");
        _tagNameMap.put(12, "Exposure Program");
        _tagNameMap.put(13, "Date/Time Original");
        _tagNameMap.put(14, "Date/Time Digitized");
    }
}

