/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.io.File;
import java.util.List;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.util.ErrorHandler;
import omero.model.Pixels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OMEROImportFixture {
    Logger log = LoggerFactory.getLogger(OMEROImportFixture.class);
    protected OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private ImportLibrary library;
    private File file;
    private List<Pixels> pixels;
    private ErrorHandler.EXCEPTION_EVENT exception = null;
    private String name;

    public OMEROImportFixture(OMEROMetadataStoreClient store, OMEROWrapper reader) {
        this.store = store;
        this.reader = reader;
    }

    public void setUp() throws Exception {
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public void tearDown() {
        if (this.store != null) {
            this.store.logout();
            this.store = null;
        }
        this.library = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pixels> fullImport(File f, String name) throws Exception {
        this.setUp();
        try {
            this.setFile(f);
            this.setName(name);
            this.doImport();
            List<Pixels> list = this.getPixels();
            return list;
        }
        finally {
            this.tearDown();
        }
    }

    public void doImport() throws Exception {
        String fileName = this.file.getAbsolutePath();
        ImportConfig config = new ImportConfig();
        ErrorHandler handler = new ErrorHandler(config){

            @Override
            public void onUpdate(IObservable importLibrary, ImportEvent event) {
                if (event instanceof ImportEvent.IMPORT_DONE) {
                    OMEROImportFixture.this.pixels = ((ImportEvent.IMPORT_DONE)event).pixels;
                } else if (event instanceof ErrorHandler.EXCEPTION_EVENT) {
                    OMEROImportFixture.this.exception = (ErrorHandler.EXCEPTION_EVENT)event;
                }
            }
        };
        ImportCandidates candidates = new ImportCandidates(this.reader, new String[]{fileName}, handler);
        this.library.addObserver(handler);
        this.library.importCandidates(config, candidates);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Pixels> getPixels() throws Exception {
        if (this.exception != null) {
            throw this.exception.exception;
        }
        return this.pixels;
    }
}

