/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import loci.formats.FileInfo;
import loci.formats.MissingLibraryException;
import loci.formats.UnknownFormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import ome.formats.ImageNameMetadataStore;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.util.ErrorHandler;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCandidates
extends DirectoryWalker {
    private static final Logger log = LoggerFactory.getLogger(ImportCandidates.class);
    public static final int DEPTH = Integer.valueOf(System.getProperty("omero.import.depth", "4"));
    public static final MetadataLevel METADATA_LEVEL = MetadataLevel.valueOf((String)System.getProperty("omero.import.metadata.level", "MINIMUM"));
    private final IObserver observer;
    private final OMEROWrapper reader;
    private final Set<String> allFiles = new HashSet<String>();
    private final Map<String, List<String>> usedBy = new LinkedHashMap<String, List<String>>();
    private final List<ImportContainer> containers = new ArrayList<ImportContainer>();
    private final long start = System.currentTimeMillis();
    long readerTime = 0L;
    int setids = 0;
    int unknown = 0;
    int count = 0;
    int total = -1;
    boolean cancelled = false;

    public ImportCandidates(OMEROWrapper reader, String[] paths, IObserver observer) {
        this(DEPTH, reader, paths, observer);
    }

    public ImportCandidates(int depth, OMEROWrapper reader, String[] paths, IObserver observer) {
        super((FileFilter)TrueFileFilter.INSTANCE, depth);
        this.reader = reader;
        this.observer = observer;
        log.info(String.format("Depth: %s Metadata Level: %s", depth, METADATA_LEVEL));
        if (paths != null && paths.length == 2 && "".equals(paths[0]) && "".equals(paths[1])) {
            System.exit(0);
            return;
        }
        if (paths == null || paths.length == 0) {
            return;
        }
        try {
            this.execute(paths);
            this.total = this.count;
            this.count = 0;
            this.execute(paths);
            Groups g = new Groups(this.usedBy);
            g.parse(this.containers);
            long totalElapsed = System.currentTimeMillis() - this.start;
            log.info(String.format("%s file(s) parsed into %s group(s) with %s call(s) to setId in %sms. (%sms total) [%s unknowns]", this.total, this.size(), this.setids, this.readerTime, totalElapsed, this.unknown));
        }
        catch (CANCEL c) {
            log.info(String.format("Cancelling search after %sms with %s containers found (%sms in %s calls to setIds)", System.currentTimeMillis() - this.start, this.containers.size(), this.readerTime, this.setids));
            this.containers.clear();
            this.cancelled = true;
            Object g = null;
            this.total = -1;
            this.count = -1;
        }
    }

    public void print() {
        if (this.containers == null) {
            return;
        }
        for (ImportContainer container : this.containers) {
            System.out.println("#======================================");
            System.out.println(String.format("# Group: %s SPW: %s Reader: %s", container.getFile(), container.getIsSPW(), container.getReader()));
            for (String file : container.getUsedFiles()) {
                System.out.println(file);
            }
        }
    }

    public void printYaml() {
        if (this.containers == null) {
            return;
        }
        System.out.println("---");
        for (ImportContainer container : this.containers) {
            System.out.println("- group: " + container.getFile());
            System.out.println("  spw: " + container.getIsSPW());
            System.out.println("  reader: " + container.getReader());
            System.out.println("  files:");
            for (String file : container.getUsedFiles()) {
                System.out.println("   - " + file);
            }
        }
    }

    public int size() {
        return this.containers.size();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (ImportContainer i : this.containers) {
            paths.add(i.getFile().getAbsolutePath());
        }
        return paths;
    }

    public String getReaderType(String path) {
        for (ImportContainer i : this.containers) {
            if (!i.getFile().getAbsolutePath().equals(path)) continue;
            return i.getReader();
        }
        throw new RuntimeException("Unfound reader for: " + path);
    }

    public String[] getUsedFiles(String path) {
        for (ImportContainer i : this.containers) {
            if (!i.getFile().getAbsolutePath().equals(path)) continue;
            return i.getUsedFiles();
        }
        throw new RuntimeException("Unfound reader for: " + path);
    }

    public List<ImportContainer> getContainers() {
        return new ArrayList<ImportContainer>(this.containers);
    }

    protected void execute(String[] paths) {
        for (String string : paths) {
            try {
                File f = new File(string);
                if (f.isDirectory()) {
                    this.walk(f, null);
                } else {
                    this.handleFile(f, 0, null);
                }
                this.scanWithCancel(f, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportContainer singleFile(File file, ImportConfig config) {
        block10: {
            ImportContainer importContainer;
            if (file == null) {
                return null;
            }
            String path = file.getAbsolutePath();
            if (!file.exists() || !file.canRead()) {
                this.safeUpdate(new ErrorHandler.UNREADABLE_FILE(path, new FileNotFoundException(path), (Object)this));
                return null;
            }
            String format = null;
            String[] usedFiles = new String[]{path};
            long start = System.currentTimeMillis();
            try {
                ++this.setids;
                this.reader.close();
                this.reader.setMetadataStore((MetadataStore)new ImageNameMetadataStore());
                this.reader.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(METADATA_LEVEL));
                this.reader.setId(path);
                format = this.reader.getFormat();
                usedFiles = this.getOrderedFiles();
                String[] domains = this.reader.getReader().getDomains();
                boolean isSPW = Arrays.asList(domains).contains("High-Content Screening (HCS)");
                String readerClassName = this.reader.unwrap().getClass().getCanonicalName();
                ImportContainer ic = new ImportContainer(config, file, null, null, readerClassName, usedFiles, isSPW);
                ic.setDoThumbnails((Boolean)config.doThumbnails.get());
                ic.setNoStatsInfo((Boolean)config.noStatsInfo.get());
                String configImageName = (String)config.userSpecifiedName.get();
                ic.setUserSpecifiedName(configImageName);
                ic.setUserSpecifiedDescription((String)config.userSpecifiedDescription.get());
                ic.setCustomAnnotationList((List)config.annotations.get());
                importContainer = ic;
            }
            catch (Throwable throwable) {
                try {
                    this.readerTime += System.currentTimeMillis() - start;
                    this.reader.close();
                    throw throwable;
                }
                catch (UnsupportedCompressionException uce) {
                    ++this.unknown;
                    this.safeUpdate(new ErrorHandler.UNKNOWN_FORMAT(path, (Exception)((Object)uce), (Object)this));
                    break block10;
                }
                catch (UnknownFormatException ufe) {
                    ++this.unknown;
                    this.safeUpdate(new ErrorHandler.UNKNOWN_FORMAT(path, (Exception)((Object)ufe), (Object)this));
                    break block10;
                }
                catch (MissingLibraryException mle) {
                    this.safeUpdate(new ErrorHandler.MISSING_LIBRARY(path, mle, usedFiles, format));
                    break block10;
                }
                catch (Throwable t) {
                    Exception e = null;
                    e = t instanceof Exception ? (Exception)t : new Exception(t);
                    this.safeUpdate(new ErrorHandler.FILE_EXCEPTION(path, e, usedFiles, format));
                }
            }
            this.readerTime += System.currentTimeMillis() - start;
            this.reader.close();
            return importContainer;
        }
        return null;
    }

    private List<String> getImageNames() {
        ArrayList<String> toReturn = new ArrayList<String>();
        Map<Integer, String> imageNames = ((ImageNameMetadataStore)this.reader.getMetadataStore()).getImageNames();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            toReturn.add(imageNames.get(i));
        }
        return toReturn;
    }

    private String[] getOrderedFiles() {
        int i;
        FileInfo[] infos = this.reader.getAdvancedUsedFiles(false);
        String[] usedFiles = new String[infos.length];
        int count = 0;
        for (i = 0; i < usedFiles.length; ++i) {
            if (!infos[i].usedToInitialize) continue;
            usedFiles[count++] = infos[i].filename;
        }
        for (i = 0; i < usedFiles.length; ++i) {
            if (infos[i].usedToInitialize) continue;
            usedFiles[count++] = infos[i].filename;
        }
        return usedFiles;
    }

    private void scanWithCancel(File f, int d) throws CANCEL {
        SCANNING s = new SCANNING(f, d, this.count, this.total);
        this.safeUpdate(s);
        if (s.cancel) {
            throw new CANCEL();
        }
    }

    private void safeUpdate(ImportEvent event) {
        try {
            this.observer.update(null, event);
        }
        catch (Exception ex) {
            log.error(String.format("Error on %s with %s", this.observer, event), (Throwable)ex);
        }
    }

    public void handleFile(File file, int depth, Collection collection) {
        ++this.count;
        if (file.getName().startsWith(".")) {
            return;
        }
        if (this.count % 100 == 0) {
            this.scanWithCancel(file, depth);
        }
        if (this.total < 0) {
            return;
        }
        if (this.allFiles.contains(file.getAbsolutePath())) {
            return;
        }
        ImportContainer info = this.singleFile(file, this.reader.getConfig());
        if (info == null) {
            return;
        }
        this.containers.add(info);
        this.allFiles.addAll(Arrays.asList(info.getUsedFiles()));
        for (String string : info.getUsedFiles()) {
            List<String> users = this.usedBy.get(string);
            if (users == null) {
                users = new ArrayList<String>();
                this.usedBy.put(string, users);
            }
            users.add(file.getAbsolutePath());
        }
    }

    private static class Groups {
        private final Map<String, List<String>> usedBy;
        private final Map<String, Group> groups = new LinkedHashMap<String, Group>();
        private List<String> ordering;

        Groups(Map<String, List<String>> usedBy) {
            this.usedBy = usedBy;
            for (String key : usedBy.keySet()) {
                this.groups.put(key, new Group(key));
            }
        }

        public int size() {
            return this.ordering.size();
        }

        public List<String> getPaths() {
            this.size();
            return this.ordering;
        }

        Groups parse(List<ImportContainer> containers) {
            if (this.ordering != null) {
                throw new RuntimeException("Already ordered");
            }
            for (Group g : new ArrayList<Group>(this.groups.values())) {
                g.removeSelfIfSingular();
            }
            this.ordering = new ArrayList<String>(this.groups.keySet());
            ArrayList<ImportContainer> copy = new ArrayList<ImportContainer>(containers);
            containers.clear();
            for (String key : this.ordering) {
                for (ImportContainer importContainer : copy) {
                    if (!importContainer.getFile().getAbsolutePath().equals(key)) continue;
                    containers.add(importContainer);
                }
            }
            for (ImportContainer c : containers) {
                c.setFile(new File(c.getUsedFiles()[0]));
                c.updateUsedFilesTotalSize();
            }
            return this;
        }

        void print() {
            Collection<Group> values = this.groups.values();
            if (values.size() == 1) {
                System.out.println(values.iterator().next().toShortString());
            } else {
                for (Group g : values) {
                    System.out.println(g);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Group g : this.groups.values()) {
                sb.append(g.toString());
                sb.append("\n");
            }
            return sb.toString();
        }

        static void line(String s) {
            System.out.println("\n# ************ " + s + " ************ \n");
        }

        static Groups test(int count, Map<String, List<String>> t) {
            System.out.println("\n\n");
            Groups.line("TEST " + count);
            Groups g = new Groups(t);
            System.out.println(g);
            g.parse(new ArrayList<ImportContainer>());
            Groups.line("RESULT " + count);
            System.out.println(g);
            return g;
        }

        static Groups test() {
            System.out.println("\n");
            Groups.line("NOTICE");
            System.out.println("#  You have entered \"\" \"\" as the path to import.");
            System.out.println("#  This runs the test suite. If you would like to");
            System.out.println("#  import the current directory use \"\".");
            LinkedHashMap<String, List<String>> t = new LinkedHashMap<String, List<String>>();
            t.put("a.dv.log", Arrays.asList("b.dv"));
            t.put("b.dv", Arrays.asList("b.dv"));
            Groups.test(1, t);
            t = new LinkedHashMap();
            t.put("a.png", Arrays.asList("a.png"));
            Groups.test(2, t);
            t = new LinkedHashMap();
            t.put("a.tiff", Arrays.asList("a.tiff", "c.lei"));
            t.put("b.tiff", Arrays.asList("b.tiff", "c.lei"));
            t.put("c.lei", Arrays.asList("c.lei"));
            Groups.test(3, t);
            t = new LinkedHashMap();
            t.put("overlay.tiff", Arrays.asList("overlay.tiff"));
            t.put("b.tiff", Arrays.asList("b.tiff", "overlay.tiff"));
            return Groups.test(4, t);
        }

        private class Group {
            String key;
            List<String> theyUseMe;
            List<String> iUseThem;

            public Group(String key) {
                this.key = key;
                this.theyUseMe = new ArrayList<String>((Collection)Groups.this.usedBy.get(key));
                this.theyUseMe.remove(key);
                this.iUseThem = new ArrayList<String>();
                for (Map.Entry entry : Groups.this.usedBy.entrySet()) {
                    if (!((List)entry.getValue()).contains(key)) continue;
                    this.iUseThem.add((String)entry.getKey());
                }
                this.iUseThem.remove(key);
            }

            public void removeSelfIfSingular() {
                int users = this.theyUseMe.size();
                int used = this.iUseThem.size();
                if (used < users) {
                    Groups.this.groups.remove(this.key);
                }
            }

            public String toShortString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.key);
                sb.append("\n");
                for (String val : this.iUseThem) {
                    sb.append(val);
                    sb.append("\n");
                }
                return sb.toString();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("#======================================\n");
                sb.append("# Group: " + this.key);
                sb.append("\n");
                sb.append(this.key);
                sb.append("\n");
                for (String val : this.iUseThem) {
                    sb.append(val);
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
    }

    public static class CANCEL
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class SCANNING
    extends ImportEvent {
        public final File file;
        public final int depth;
        public final int numFiles;
        public final int totalFiles;
        private boolean cancel = false;

        public SCANNING(File file, int depth, int numFiles, int totalFiles) {
            this.file = file;
            this.depth = depth;
            this.numFiles = numFiles;
            this.totalFiles = totalFiles;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public String toLog() {
            int l = this.file.toString().length() - 16;
            if (l < 0) {
                l = 0;
            }
            String f = this.file.toString().substring(l);
            return super.toLog() + String.format(": Depth:%s Num: %4s Tot: %4s File: %s", this.depth, this.numFiles, this.totalFiles < 0 ? "n/a" : Integer.valueOf(this.totalFiles), f);
        }
    }
}

