/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.targets;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.targets.ImportTarget;
import omero.RString;
import omero.api.IQueryPrx;
import omero.api.IUpdatePrx;
import omero.model.IObject;
import omero.rtypes;
import omero.sys.ParametersI;
import omero.util.IceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelImportTarget
implements ImportTarget {
    private static final Logger log = LoggerFactory.getLogger(ModelImportTarget.class);
    private static final List<String> VALID_TYPES = Arrays.asList("omero.model.Dataset", "omero.model.Screen");
    private Class<? extends IObject> type;
    private String typeName;
    private String simpleName;
    private String prefix;
    private Long id;
    private String discriminator;
    private String template;
    private String name;

    @Override
    public void init(String target) {
        String[] tokens = target.split(":", 3);
        this.prefix = tokens[0];
        if (tokens.length == 2) {
            this.name = tokens[1];
            this.discriminator = "id";
        } else {
            this.name = tokens[2];
            this.discriminator = tokens[1];
        }
        this.type = this.tryClass(this.prefix);
        Class k = IceMap.OMEROtoOME.get(this.type);
        this.typeName = k.getName();
        this.simpleName = k.getSimpleName();
        this.type = IceMap.OMEtoOMERO.get(k);
    }

    private Class<? extends IObject> tryClass(String prefix) {
        Class<?> klass = null;
        try {
            klass = Class.forName(prefix);
        }
        catch (Exception e) {
            try {
                klass = Class.forName("omero.model." + prefix);
            }
            catch (Exception e1) {
                throw new RuntimeException("Unknown class:" + prefix);
            }
        }
        if (!VALID_TYPES.contains(klass.getName())) {
            throw new RuntimeException("Not a valid container class:" + klass.getName());
        }
        return klass;
    }

    public Class<? extends IObject> getObjectType() {
        return this.type;
    }

    public Long getObjectId() {
        return this.id;
    }

    @Override
    public IObject load(OMEROMetadataStoreClient client2, ImportContainer ic) throws Exception {
        IQueryPrx query = client2.getServiceFactory().getQueryService();
        IUpdatePrx update = client2.getServiceFactory().getUpdateService();
        if (this.discriminator.matches("^[-+%@]?name$")) {
            IObject obj;
            List<IObject> objs;
            String order = "desc";
            if (this.discriminator.startsWith("-")) {
                order = "asc";
            }
            if ((objs = query.findAllByQuery("select o from " + this.simpleName + " as o where o.name = :name order by o.id " + order, new ParametersI().add("name", rtypes.rstring(this.name)))).size() == 0 || this.discriminator.startsWith("@")) {
                obj = this.type.newInstance();
                Method m = this.type.getMethod("setName", RString.class);
                m.invoke((Object)obj, rtypes.rstring(this.name));
                obj = update.saveAndReturnObject(obj);
            } else {
                if (this.discriminator.startsWith("%") && objs.size() > 1) {
                    log.error("No unique {} called {}", (Object)this.simpleName, (Object)this.name);
                    throw new RuntimeException("No unique " + this.simpleName + " available");
                }
                obj = objs.get(0);
            }
            this.id = obj.getId().getValue();
        } else if (this.discriminator.equals("id")) {
            this.id = Long.valueOf(this.name);
        } else {
            log.error("Unknown discriminator {}", (Object)this.discriminator);
            throw new RuntimeException("Unknown discriminator " + this.discriminator);
        }
        return query.get(this.type.getSimpleName(), this.id);
    }
}

