/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.targets;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.targets.TemplateImportTarget;
import omero.api.IQueryPrx;
import omero.api.IUpdatePrx;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.IObject;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.rtypes;
import omero.sys.ParametersI;

public class ServerTemplateImportTarget
extends TemplateImportTarget {
    private final String sharedPath;

    public ServerTemplateImportTarget(String sharedPath) {
        this.sharedPath = sharedPath;
    }

    @Override
    public IObject load(OMEROMetadataStoreClient client2, ImportContainer ic) throws Exception {
        return this.load(client2, ic.getIsSPW());
    }

    public IObject load(OMEROMetadataStoreClient client2, boolean spw) throws Exception {
        Dataset dataset;
        IQueryPrx query = client2.getServiceFactory().getQueryService();
        IUpdatePrx update = client2.getServiceFactory().getUpdateService();
        this.log.info("Checking '{}' against '{}'", (Object)this.sharedPath, (Object)this.getTemplate());
        Pattern pattern = Pattern.compile(this.getTemplate());
        Matcher m = pattern.matcher(this.sharedPath);
        if (!m.matches()) {
            this.log.warn("No match");
            return null;
        }
        if (!this.getDiscriminator().matches("^[-+%@]?name$")) {
            this.log.warn("Invalid discriminator: {}", (Object)this.getDiscriminator());
            return null;
        }
        String name = m.group("Container1");
        if (name == null || name.trim().length() == 0) {
            this.log.warn("Empty name");
            return null;
        }
        String order = "desc";
        if (this.getDiscriminator().startsWith("-")) {
            order = "asc";
        }
        if (spw) {
            Screen screen;
            List<IObject> screens = query.findAllByQuery("select o from Screen as o where o.name = :name order by o.id " + order, new ParametersI().add("name", rtypes.rstring(name)));
            if (screens.size() == 0 || this.getDiscriminator().startsWith("@")) {
                screen = new ScreenI();
                screen.setName(rtypes.rstring(name));
                screen = (Screen)update.saveAndReturnObject(screen);
            } else {
                if (this.getDiscriminator().startsWith("%") && screens.size() > 1) {
                    this.log.warn("No unique Screen called {}", (Object)name);
                    return null;
                }
                screen = (Screen)screens.get(0);
            }
            return screen;
        }
        List<IObject> datasets = query.findAllByQuery("select o from Dataset as o where o.name = :name order by o.id " + order, new ParametersI().add("name", rtypes.rstring(name)));
        if (datasets.size() == 0 || this.getDiscriminator().startsWith("@")) {
            dataset = new DatasetI();
            dataset.setName(rtypes.rstring(name));
            dataset = (Dataset)update.saveAndReturnObject(dataset);
        } else {
            if (this.getDiscriminator().startsWith("%") && datasets.size() > 1) {
                this.log.warn("No unique Dataset called {}", (Object)name);
                return null;
            }
            dataset = (Dataset)datasets.get(0);
        }
        return dataset;
    }
}

