/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.UserException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.xml.XMLTools;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import ome.api.RawPixelsStore;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.io.nio.PixelsService;
import ome.io.nio.RomioPixelBuffer;
import ome.model.core.Pixels;
import ome.services.blitz.impl.AbstractCloseableAmdServant;
import ome.services.blitz.impl.OmeroMetadata;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.db.DatabaseIdentity;
import ome.services.formats.OmeroReader;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OME;
import omero.ServerError;
import omero.api.AMD_Exporter_addImage;
import omero.api.AMD_Exporter_generateTiff;
import omero.api.AMD_Exporter_generateXml;
import omero.api.AMD_Exporter_read;
import omero.api._ExporterOperations;
import omero.model.ImageI;
import omero.util.IceMapper;
import omero.util.TempFileManager;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExporterI
extends AbstractCloseableAmdServant
implements _ExporterOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Logger log = LoggerFactory.getLogger(ExporterI.class);
    private static final int MAX_SIZE = 0x100000;
    private static final long BIG_TIFF_SIZE = 0xFFFFFFFEL;
    private ServiceFactoryI factory;
    private volatile OmeroMetadata retrieve;
    private volatile File file;
    private final DatabaseIdentity databaseIdentity;
    private final OMEXMLService service;
    private final PixelsService pixelsService;

    public ExporterI(BlitzExecutor be, DatabaseIdentity databaseIdentity, PixelsService pixelsService) throws DependencyException {
        super(null, be);
        this.databaseIdentity = databaseIdentity;
        this.pixelsService = pixelsService;
        this.retrieve = new OmeroMetadata(databaseIdentity);
        loci.common.services.ServiceFactory sf = new loci.common.services.ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.factory = sf;
    }

    @Override
    public void addImage_async(AMD_Exporter_addImage __cb, long id, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.retrieve.addImage(new ImageI(id, false));
        __cb.ice_response();
    }

    @Override
    public void generateXml_async(AMD_Exporter_generateXml __cb, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.do_xml(__cb);
    }

    @Override
    public void generateTiff_async(AMD_Exporter_generateTiff __cb, Current __current) throws ServerError {
        State state = State.check(this);
        ServerError se = this.assertConfig(state);
        if (se != null) {
            __cb.ice_exception((Exception)((Object)se));
        }
        this.do_tiff(__cb);
    }

    @Override
    public void read_async(AMD_Exporter_read __cb, long pos, int size, Current __current) throws ServerError {
        State state = State.check(this);
        switch (state) {
            case config: {
                omero.ApiUsageException aue = new omero.ApiUsageException(null, null, "Call a generate method first");
                __cb.ice_exception((Exception)((Object)aue));
                return;
            }
            case output: {
                try {
                    __cb.ice_response(this.read(pos, size));
                }
                catch (Exception e) {
                    if (e instanceof ServerError) {
                        __cb.ice_exception(e);
                    }
                    omero.InternalException ie = new omero.InternalException(null, null, "Error during read");
                    IceMapper.fillServerError(ie, e);
                    __cb.ice_exception((Exception)((Object)ie));
                }
                return;
            }
        }
        throw new InternalException("Unknown state: " + (Object)((Object)state));
    }

    private ServerError assertConfig(State state) {
        switch (state) {
            case config: {
                return null;
            }
            case output: {
                return new omero.ApiUsageException(null, null, "Cannot configure during output");
            }
        }
        return new omero.InternalException(null, null, "Unknown state: " + (Object)((Object)state));
    }

    private void startConfig() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    private void do_xml(final AMD_Exporter_generateXml __cb) {
        try {
            this.factory.getExecutor().execute(this.factory.getPrincipal(), (Executor.Work)new Executor.SimpleWork(this, "generateXml", new Object[0]){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    MetadataRoot root;
                    ExporterI.this.retrieve.initialize(session);
                    IMetadata xmlMetadata = null;
                    try {
                        xmlMetadata = ExporterI.this.convertXml((MetadataRetrieve)ExporterI.this.retrieve);
                    }
                    catch (ServiceException e) {
                        log.error(e.toString());
                        return null;
                    }
                    if (xmlMetadata != null && (root = xmlMetadata.getRoot()) instanceof OME) {
                        OME node = (OME)root;
                        List images = node.copyImageList();
                        for (Image img : images) {
                            img.getPixels().setMetadataOnly(new MetadataOnly());
                        }
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder parser = factory.newDocumentBuilder();
                            Document document = parser.newDocument();
                            Element element = node.asXMLElement(document);
                            document.appendChild(element);
                            ExporterI.this.file = TempFileManager.create_path("__omero_export__", ".ome.xml");
                            ExporterI.this.file.deleteOnExit();
                            FileOutputStream fos = new FileOutputStream(ExporterI.this.file);
                            XMLTools.writeXML((OutputStream)fos, (Document)document);
                            fos.close();
                            ExporterI.this.retrieve = null;
                            __cb.ice_response(ExporterI.this.file.length());
                            return null;
                        }
                        catch (IOException ioe) {
                            log.error(ioe.toString());
                        }
                        catch (TransformerException e) {
                            log.error(e.toString());
                        }
                        catch (ParserConfigurationException e) {
                            log.error(e.toString());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            IceMapper mapper = new IceMapper();
            UserException ue = mapper.handleException(e, this.factory.getExecutor().getContext());
            __cb.ice_exception((Exception)((Object)ue));
        }
    }

    private void do_tiff(final AMD_Exporter_generateTiff __cb) {
        try {
            this.factory.executor.execute(this.factory.principal, (Executor.Work)new Executor.SimpleWork(this, "generateTiff", new Object[0]){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    ExporterI.this.retrieve.initialize(session);
                    int num = ExporterI.this.retrieve.sizeImages();
                    if (num != 1) {
                        omero.ApiUsageException a = new omero.ApiUsageException(null, null, "Only one image supported for TIFF, not " + num);
                        __cb.ice_exception((Exception)((Object)a));
                        return null;
                    }
                    RawPixelsStore raw = null;
                    OmeroReader reader = null;
                    OMETiffWriter writer = null;
                    try {
                        boolean bigtiff;
                        omero.model.Image image = ExporterI.this.retrieve.getImage(0);
                        omero.model.Pixels pix = image.getPixels(0);
                        if (ExporterI.this.requiresPyramid(sf, pix.getId().getValue())) {
                            long id = image.getId().getValue();
                            int x = pix.getSizeX().getValue();
                            int y = pix.getSizeY().getValue();
                            throw new omero.ApiUsageException(null, null, String.format("Image:%s is too large for export (sizeX=%s, sizeY=%s)", id, x, y));
                        }
                        ExporterI.this.file = TempFileManager.create_path("__omero_export__", ".ome.tiff");
                        raw = sf.createRawPixelsStore();
                        raw.setPixelsId(pix.getId().getValue(), true);
                        reader = new OmeroReader(raw, pix);
                        reader.setId("OMERO");
                        writer = new OMETiffWriter();
                        writer.setMetadataRetrieve((MetadataRetrieve)ExporterI.this.retrieve);
                        writer.setWriteSequentially(true);
                        long mSize = ExporterI.this.getMetadataBytes(reader);
                        long dSize = ExporterI.this.getDataBytes(reader);
                        boolean bl = bigtiff = mSize + dSize > 0xFFFFFFFEL;
                        if (bigtiff) {
                            writer.setBigTiff(true);
                        }
                        writer.setId(ExporterI.this.file.getAbsolutePath());
                        int planeCount = reader.planes;
                        int planeSize = RomioPixelBuffer.safeLongToInteger((Long)raw.getPlaneSize());
                        log.info(String.format("Using big TIFF? %s mSize=%d dSize=%d planeCount=%d planeSize=%d", bigtiff, mSize, dSize, planeCount, planeSize));
                        byte[] plane = new byte[planeSize];
                        for (int i = 0; i < planeCount; ++i) {
                            int[] zct = FormatTools.getZCTCoords((String)ExporterI.this.retrieve.getPixelsDimensionOrder(0).getValue(), (int)reader.getSizeZ(), (int)reader.getSizeC(), (int)reader.getSizeT(), (int)planeCount, (int)i);
                            int readerIndex = reader.getIndex(zct[0], zct[1], zct[2]);
                            reader.openBytes(readerIndex, plane);
                            IFD ifd = new IFD();
                            ifd.put((Object)322, (Object)128);
                            ifd.put((Object)323, (Object)128);
                            writer.saveBytes(i, plane, ifd);
                        }
                        ExporterI.this.retrieve = null;
                        try {
                            writer.close();
                        }
                        finally {
                            writer = null;
                        }
                        __cb.ice_response(ExporterI.this.file.length());
                        this.cleanup(raw, reader, (IFormatWriter)writer);
                    }
                    catch (Exception e) {
                        omero.InternalException ie = new omero.InternalException(null, null, "Error during TIFF generation");
                        IceMapper.fillServerError(ie, e);
                        __cb.ice_exception((Exception)((Object)ie));
                    }
                    finally {
                        this.cleanup(raw, reader, (IFormatWriter)writer);
                    }
                    return null;
                }

                private void cleanup(RawPixelsStore raw, OmeroReader reader, IFormatWriter writer) {
                    try {
                        if (raw != null) {
                            raw.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Error closing pix", (Throwable)e);
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Error closing reader", (Throwable)e);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Error closing writer", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            IceMapper mapper = new IceMapper();
            UserException ue = mapper.handleException(e, this.factory.getExecutor().getContext());
            __cb.ice_exception((Exception)((Object)ue));
        }
    }

    private byte[] read(long pos, int size) throws ServerError {
        if (size > 0x100000) {
            throw new ApiUsageException("Max read size is: 1048576");
        }
        byte[] buf = new byte[size];
        RandomAccessFile ra = null;
        try {
            ra = new RandomAccessFile(this.file, "r");
            long l = ra.length();
            if (pos + (long)size > l) {
                size = (int)(l - pos);
            }
            ra.seek(pos);
            int read = ra.read(buf);
            if (read < 0) {
                buf = new byte[]{};
            } else if (read < size) {
                byte[] newBuf = new byte[read];
                System.arraycopy(buf, 0, newBuf, 0, read);
                buf = newBuf;
            }
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        finally {
            if (ra != null) {
                try {
                    ra.close();
                }
                catch (IOException e) {
                    log.warn("IOException on file close");
                }
            }
        }
        return buf;
    }

    public IMetadata convertXml(MetadataRetrieve retrieve) throws ServiceException {
        OMEXMLMetadata xmlMeta = this.service.createOMEXMLMetadata();
        xmlMeta.createRoot();
        this.service.convertMetadata(retrieve, (MetadataStore)xmlMeta);
        return xmlMeta;
    }

    public String generateXml(MetadataRetrieve retrieve) throws ServiceException {
        IMetadata xmlMeta = this.convertXml(retrieve);
        return this.service.getOMEXML((MetadataRetrieve)xmlMeta);
    }

    @Override
    protected void preClose(Current current) {
        this.retrieve = null;
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    @Override
    protected void postClose(Current current) {
    }

    private long getMetadataBytes(OmeroReader reader) throws DependencyException, ServiceException {
        long xmlbytes;
        String xml = this.service.getOMEXML((MetadataRetrieve)this.retrieve);
        try {
            xmlbytes = xml.getBytes("UTF8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to convert to UTF-8", e);
        }
        long planebytes = reader.planes * 512;
        return planebytes + xmlbytes;
    }

    private long getDataBytes(OmeroReader reader) {
        return (long)reader.planes * (long)reader.sizeX * (long)reader.sizeY * (long)FormatTools.getBytesPerPixel((int)reader.getPixelType());
    }

    private boolean requiresPyramid(ServiceFactory sf, long id) {
        Pixels _p = (Pixels)sf.getQueryService().get(Pixels.class, id);
        return this.pixelsService.requiresPixelsPyramid(_p);
    }

    private static enum State {
        config,
        output;


        static State check(ExporterI self) {
            if (self.file != null && self.retrieve != null) {
                throw new InternalException("Doing 2 things at once");
            }
            if (self.retrieve == null) {
                return output;
            }
            return config;
        }
    }
}

