/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.AsyncResult;
import Ice.Callback;
import Ice.Current;
import Ice.Identity;
import Ice.LocalException;
import Ice.NotRegisteredException;
import Ice.ObjectPrx;
import Ice.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import ome.api.JobHandle;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.AbstractCloseableAmdServant;
import ome.services.blitz.impl.ProcessorCallbackI;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ParamsCache;
import ome.services.blitz.util.ResultHolder;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.scripts.ScriptRepoHelper;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import omero.ApiUsageException;
import omero.NoProcessorAvailable;
import omero.RTime;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.InteractiveProcessorI;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.InteractiveProcessorPrxHelper;
import omero.grid.InternalRepositoryPrx;
import omero.grid.ParamsHelper;
import omero.grid.ProcessorPrx;
import omero.grid.RepositoryMap;
import omero.grid.RepositoryPrx;
import omero.grid.TablePrx;
import omero.grid.TablePrxHelper;
import omero.grid.TablesPrx;
import omero.grid.TablesPrxHelper;
import omero.grid._InteractiveProcessorTie;
import omero.grid._SharedResourcesOperations;
import omero.model.Job;
import omero.model.JobStatusI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.rtypes;
import omero.util.IceMapper;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SharedResourcesI
extends AbstractCloseableAmdServant
implements _SharedResourcesOperations,
BlitzOnly,
ServiceFactoryAware,
ParamsHelper.Acquirer {
    public static final long DEFAULT_TIMEOUT = 3600000L;
    private static final Logger log = LoggerFactory.getLogger(SharedResourcesI.class);
    private final Set<String> tableIds = new HashSet<String>();
    private final Set<String> processorIds = new HashSet<String>();
    private final TopicManager topicManager;
    private final Registry registry;
    private final ScriptRepoHelper helper;
    private final ParamsCache paramsCache;
    private final long waitMillis;
    private final long timeout;
    private ServiceFactoryI sf;
    static String QUERY = "select o from OriginalFile o where o.mimetype = 'Repository'";

    public SharedResourcesI(BlitzExecutor be, TopicManager topicManager, Registry registry, ScriptRepoHelper helper, ParamsCache cache) {
        this(be, topicManager, registry, helper, cache, 5000L);
    }

    public SharedResourcesI(BlitzExecutor be, TopicManager topicManager, Registry registry, ScriptRepoHelper helper, ParamsCache cache, long waitMillis) {
        this(be, topicManager, registry, helper, cache, waitMillis, 3600000L);
    }

    public SharedResourcesI(BlitzExecutor be, TopicManager topicManager, Registry registry, ScriptRepoHelper helper, ParamsCache cache, long waitMillis, long timeout) {
        super(null, be);
        this.waitMillis = waitMillis;
        this.topicManager = topicManager;
        this.registry = registry;
        this.helper = helper;
        this.paramsCache = cache;
        this.timeout = timeout;
        if (timeout > 31536000000L) {
            throw new InternalException("Timeout too large: " + timeout);
        }
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose(Current current) {
        Set<String> set = this.tableIds;
        synchronized (set) {
            for (String id : this.tableIds) {
                TablePrx table = TablePrxHelper.uncheckedCast(this.sf.adapter.getCommunicator().stringToProxy(id));
                try {
                    table.close();
                }
                catch (NotRegisteredException e) {
                    log.debug("Table already gone: " + id);
                }
                catch (Exception e) {
                    log.error("Exception while closing table " + id, (Throwable)e);
                }
            }
            this.tableIds.clear();
        }
    }

    @Override
    protected void postClose(Current current) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(TablePrx prx) {
        if (prx != null) {
            Set<String> set = this.tableIds;
            synchronized (set) {
                this.tableIds.add(Util.identityToString((Identity)prx.ice_getIdentity()));
            }
        }
    }

    private void checkAcquisitionWait(int seconds) throws ApiUsageException {
        if (seconds > 180) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = "Delay is too long. Maximum = 3 minutes.";
            throw aue;
        }
    }

    private <U extends ObjectPrx> U lookup(long millis, List<ObjectPrx> objectPrxs, RepeatTask<U> task) throws ServerError {
        ResultHolder holder = new ResultHolder(millis);
        for (ObjectPrx prx : objectPrxs) {
            if (prx == null) continue;
            task.requestService(prx, holder);
        }
        return (U)((ObjectPrx)holder.get());
    }

    @Override
    public RepositoryPrx getScriptRepository(Current __current) throws ServerError {
        InternalRepositoryPrx[] repos = this.registry.lookupRepositories();
        InternalRepositoryPrx prx = null;
        if (repos != null) {
            for (int i = 0; i < repos.length; ++i) {
                if (repos[i] == null || !repos[i].toString().contains(this.helper.getUuid())) continue;
                prx = repos[i];
            }
        }
        return prx == null ? null : prx.getProxy();
    }

    @Override
    public RepositoryMap repositories(Current current) throws ServerError {
        IceMapper mapper = new IceMapper();
        List objs = (List)mapper.map((List)this.sf.executor.execute(current.ctx, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "acquireRepositories", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery(QUERY, null);
            }
        }));
        InternalRepositoryPrx[] repos = this.registry.lookupRepositories();
        RepositoryMap map = new RepositoryMap();
        map.descriptions = new ArrayList<OriginalFile>();
        map.proxies = new ArrayList<RepositoryPrx>();
        ArrayList<Long> found = new ArrayList<Long>();
        for (InternalRepositoryPrx i : repos) {
            if (i == null) continue;
            try {
                OriginalFile desc = i.getDescription();
                if (desc == null || desc.getId() == null) {
                    log.warn("Description is null for " + i);
                    continue;
                }
                RepositoryPrx proxy = i.getProxy();
                map.descriptions.add(desc);
                map.proxies.add(proxy);
                found.add(desc.getId().getValue());
                this.sf.allow(proxy);
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        for (OriginalFile r : objs) {
            if (found.contains(r.getId().getValue())) continue;
            map.descriptions.add(r);
            map.proxies.add(null);
        }
        return map;
    }

    @Override
    public boolean areTablesEnabled(Current __current) throws ServerError {
        TablesPrx[] tables = this.registry.lookupTables();
        return null != this.lookup(this.waitMillis, Arrays.asList(tables), new RepeatTask<TablesPrx>(){

            @Override
            public void requestService(ObjectPrx prx, ResultHolder<TablesPrx> holder) {
                TablesPrx server = TablesPrxHelper.checkedCast(prx);
                try {
                    if (server != null && server.getRepository() != null) {
                        holder.set(server);
                    }
                }
                catch (Exception e) {
                    log.debug("Exception on getRepository: " + e);
                    holder.set(null);
                }
            }
        });
    }

    @Override
    public TablePrx newTable(long repo, String path, Current __current) throws ServerError {
        final OriginalFileI file = new OriginalFileI();
        RTime time = rtypes.rtime(System.currentTimeMillis());
        file.setAtime(time);
        file.setMtime(time);
        file.setCtime(time);
        file.setMimetype(rtypes.rstring("OMERO.tables"));
        file.setPath(rtypes.rstring(path));
        file.setName(rtypes.rstring(path));
        IObject obj = (IObject)this.sf.executor.execute(__current.ctx, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "newTable", new Object[]{repo, path}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                try {
                    IObject obj = (IObject)new IceMapper().reverse(file);
                    return sf.getUpdateService().saveAndReturnObject(obj);
                }
                catch (Exception e) {
                    log.error(e.toString());
                    return null;
                }
            }
        });
        OriginalFile saved = (OriginalFile)new IceMapper().map((Filterable)obj);
        if (saved == null) {
            throw new omero.InternalException(null, null, "Failed to save file");
        }
        return this.openTable(saved, __current);
    }

    @Override
    public TablePrx openTable(final OriginalFile file, Current __current) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ValidationException(null, null, "file must be a managed instance.");
        }
        try {
            this.sf.executor.execute(__current.ctx, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "checkOriginalFilePermissions", new Object[]{file.getId().getValue()}){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return sf.getQueryService().get(ome.model.core.OriginalFile.class, file.getId().getValue());
                }
            });
        }
        catch (Exception e) {
            IceMapper mapper = new IceMapper();
            ServerError ue = mapper.handleServerError(e, this.ctx);
            throw ue;
        }
        TablesPrx[] tables = this.registry.lookupTables();
        TablePrx tablePrx = this.lookup(this.waitMillis, Arrays.asList(tables), new RepeatTask<TablePrx>(){

            @Override
            public void requestService(ObjectPrx prx, final ResultHolder holder) throws ServerError {
                final TablesPrx server = TablesPrxHelper.uncheckedCast(prx);
                HashMap<String, String> ctx = new HashMap<String, String>();
                ctx.put("omero.group", "-1");
                server.begin_getTable(file, SharedResourcesI.this.sf.proxy(), ctx, new Callback(){

                    public void completed(AsyncResult r) {
                        try {
                            holder.set(server.end_getTable(r));
                        }
                        catch (Exception e) {
                            holder.set(null);
                        }
                    }
                });
            }
        });
        this.sf.allow(tablePrx);
        this.register(tablePrx);
        return tablePrx;
    }

    @Override
    public InteractiveProcessorPrx acquireProcessor(Job submittedJob, int seconds, Current current) throws ServerError {
        this.checkAcquisitionWait(seconds);
        IceMapper mapper = new IceMapper();
        ome.model.jobs.Job savedJob = this.saveJob(submittedJob, mapper, current);
        if (savedJob == null) {
            throw new ApiUsageException(null, null, "Could not submit job. ");
        }
        ResultHolder<ProcessorPrx> holder = new ResultHolder<ProcessorPrx>(seconds * 1000);
        Job job = (Job)mapper.map((Filterable)savedJob);
        ProcessorCallbackI callback = new ProcessorCallbackI(this.sf, holder, job);
        ProcessorPrx server = callback.activateAndWait(current);
        if (server == null) {
            int count = callback.getResponses();
            String msg = String.format("No processor available! [%d response(s)]", count);
            this.updateJob(job.getId().getValue(), "Error", msg, current);
            throw new NoProcessorAvailable(null, null, msg, count);
        }
        InteractiveProcessorI ip = new InteractiveProcessorI(this.sf.principal, this.sf.sessionManager, this.sf.executor, server, job, this.timeout, this.sf.control, this.paramsCache, new ParamsHelper(this, this.sf.getExecutor(), this.sf.getPrincipal()), this.helper, current);
        Identity procId = this.sessionedID("InteractiveProcessor");
        ObjectPrx rv = this.sf.registerServant(procId, new _InteractiveProcessorTie(ip));
        this.sf.allow(rv);
        return InteractiveProcessorPrxHelper.uncheckedCast(rv);
    }

    @Override
    public void addProcessor(ProcessorPrx proc, Current __current) throws ServerError {
        this.topicManager.register("/internal/ProcessorAccept", proc, false);
        this.processorIds.add(Util.identityToString((Identity)proc.ice_getIdentity()));
        if (this.sf.control != null) {
            this.sf.control.categories().add(new String[]{"ProcessorCallback", "ProcessCallback"});
        }
    }

    @Override
    public void removeProcessor(ProcessorPrx proc, Current __current) throws ServerError {
        this.topicManager.unregister("/internal/ProcessorAccept", proc);
        this.processorIds.remove(Util.identityToString((Identity)proc.ice_getIdentity()));
    }

    private Identity sessionedID(String type) {
        String key = type + "-" + UUID.randomUUID();
        return this.sf.getIdentity(key);
    }

    private ome.model.jobs.Job saveJob(final Job submittedJob, final IceMapper mapper, Current current) {
        ome.model.jobs.Job savedJob = (ome.model.jobs.Job)this.sf.executor.execute(current.ctx, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "submitJob", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public ome.model.jobs.Job doWork(Session session, ServiceFactory sf) {
                try (JobHandle handle = sf.createJobHandle();){
                    JobStatusI status = new JobStatusI();
                    status.setValue(rtypes.rstring("Waiting"));
                    submittedJob.setStatus(status);
                    handle.submit((ome.model.jobs.Job)mapper.reverse(submittedJob));
                    ome.model.jobs.Job job = handle.getJob();
                    return job;
                }
            }
        });
        return savedJob;
    }

    private void updateJob(final long id, final String status, final String message, Current current) {
        this.sf.executor.execute(current.ctx, this.sf.principal, (Executor.Work)new Executor.SimpleWork(this, "updateJob", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                try (JobHandle handle = sf.createJobHandle();){
                    handle.attach(id);
                    handle.setStatusAndMessage(status, message);
                    Object var4_4 = null;
                    return var4_4;
                }
            }
        });
    }

    private static interface RepeatTask<U extends ObjectPrx> {
        public void requestService(ObjectPrx var1, ResultHolder<U> var2) throws ServerError;
    }
}

