/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import java.io.IOException;
import java.util.List;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import ome.io.bioformats.BfPixelsWrapper;
import ome.io.nio.RomioPixelBuffer;
import omero.ServerError;
import omero.api.AMD_PyramidService_getResolutionDescriptions;
import omero.api.AMD_PyramidService_getResolutionLevel;
import omero.api.AMD_PyramidService_getResolutionLevels;
import omero.api.AMD_PyramidService_getTileSize;
import omero.api.AMD_PyramidService_requiresPixelsPyramid;
import omero.api.AMD_PyramidService_setResolutionLevel;
import omero.api.AMD_RawPixelsStore_calculateMessageDigest;
import omero.api.AMD_RawPixelsStore_findMinMax;
import omero.api.AMD_RawPixelsStore_getByteWidth;
import omero.api.AMD_RawPixelsStore_getCol;
import omero.api.AMD_RawPixelsStore_getHistogram;
import omero.api.AMD_RawPixelsStore_getHypercube;
import omero.api.AMD_RawPixelsStore_getPixelsId;
import omero.api.AMD_RawPixelsStore_getPixelsPath;
import omero.api.AMD_RawPixelsStore_getPlane;
import omero.api.AMD_RawPixelsStore_getPlaneOffset;
import omero.api.AMD_RawPixelsStore_getPlaneRegion;
import omero.api.AMD_RawPixelsStore_getPlaneSize;
import omero.api.AMD_RawPixelsStore_getRegion;
import omero.api.AMD_RawPixelsStore_getRow;
import omero.api.AMD_RawPixelsStore_getRowOffset;
import omero.api.AMD_RawPixelsStore_getRowSize;
import omero.api.AMD_RawPixelsStore_getStack;
import omero.api.AMD_RawPixelsStore_getStackOffset;
import omero.api.AMD_RawPixelsStore_getStackSize;
import omero.api.AMD_RawPixelsStore_getTile;
import omero.api.AMD_RawPixelsStore_getTimepoint;
import omero.api.AMD_RawPixelsStore_getTimepointOffset;
import omero.api.AMD_RawPixelsStore_getTimepointSize;
import omero.api.AMD_RawPixelsStore_getTotalSize;
import omero.api.AMD_RawPixelsStore_isFloat;
import omero.api.AMD_RawPixelsStore_isSigned;
import omero.api.AMD_RawPixelsStore_prepare;
import omero.api.AMD_RawPixelsStore_save;
import omero.api.AMD_RawPixelsStore_setPixelsId;
import omero.api.AMD_RawPixelsStore_setPlane;
import omero.api.AMD_RawPixelsStore_setRegion;
import omero.api.AMD_RawPixelsStore_setRow;
import omero.api.AMD_RawPixelsStore_setStack;
import omero.api.AMD_RawPixelsStore_setTile;
import omero.api.AMD_RawPixelsStore_setTimepoint;
import omero.api.AMD_StatefulServiceInterface_activate;
import omero.api.AMD_StatefulServiceInterface_close;
import omero.api.AMD_StatefulServiceInterface_getCurrentEventContext;
import omero.api.AMD_StatefulServiceInterface_passivate;
import omero.api._RawPixelsStoreDisp;
import omero.romio.PlaneDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BfPixelsStoreI
extends _RawPixelsStoreDisp {
    private static final Logger log = LoggerFactory.getLogger(BfPixelsStoreI.class);
    private final BfPixelsWrapper reader;

    public BfPixelsStoreI(String path, ImageReader bfReader) throws IOException, FormatException {
        this.reader = new BfPixelsWrapper(path, (IFormatReader)bfReader);
    }

    @Override
    public void calculateMessageDigest_async(AMD_RawPixelsStore_calculateMessageDigest __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getMessageDigest());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getByteWidth_async(AMD_RawPixelsStore_getByteWidth __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getByteWidth());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getHypercube_async(AMD_RawPixelsStore_getHypercube __cb, List<Integer> offset, List<Integer> size, List<Integer> step, Current __current) throws ServerError {
        try {
            int hypercubeSize = RomioPixelBuffer.safeLongToInteger((Long)this.reader.getHypercubeSize(offset, size, step));
            byte[] cube = new byte[hypercubeSize];
            this.reader.getHypercube(offset, size, step, cube);
            this.reader.swapIfRequired(cube);
            __cb.ice_response(cube);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getCol_async(AMD_RawPixelsStore_getCol __cb, int x, int z, int c, int t, Current __current) throws ServerError {
        try {
            byte[] col = new byte[this.reader.getColSize().intValue()];
            this.reader.getCol(Integer.valueOf(x), Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), col);
            this.reader.swapIfRequired(col);
            __cb.ice_response(col);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getPlaneOffset_async(AMD_RawPixelsStore_getPlaneOffset __cb, int z, int c, int t, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getPlaneOffset(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t)));
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getPlaneRegion_async(AMD_RawPixelsStore_getPlaneRegion __cb, int z, int c, int t, int size, int offset, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getPlaneSize_async(AMD_RawPixelsStore_getPlaneSize __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getPlaneSize());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getPlane_async(AMD_RawPixelsStore_getPlane __cb, int z, int c, int t, Current __current) throws ServerError {
        try {
            int size = RomioPixelBuffer.safeLongToInteger((Long)this.reader.getPlaneSize());
            byte[] plane = new byte[size];
            this.reader.getPlane(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), plane);
            this.reader.swapIfRequired(plane);
            __cb.ice_response(plane);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getRegion_async(AMD_RawPixelsStore_getRegion __cb, int size, long offset, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Not yet supported, raise ticket to implement if required");
    }

    @Override
    public void getRowOffset_async(AMD_RawPixelsStore_getRowOffset __cb, int y, int z, int c, int t, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getRowOffset(Integer.valueOf(y), Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t)));
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getRowSize_async(AMD_RawPixelsStore_getRowSize __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getRowSize());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getRow_async(AMD_RawPixelsStore_getRow __cb, int y, int z, int c, int t, Current __current) throws ServerError {
        try {
            byte[] row = new byte[this.reader.getRowSize().intValue()];
            this.reader.getRow(Integer.valueOf(y), Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), row);
            this.reader.swapIfRequired(row);
            __cb.ice_response(row);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getStackOffset_async(AMD_RawPixelsStore_getStackOffset __cb, int c, int t, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getStackOffset(Integer.valueOf(c), Integer.valueOf(t)));
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getStackSize_async(AMD_RawPixelsStore_getStackSize __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getStackSize());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getStack_async(AMD_RawPixelsStore_getStack __cb, int c, int t, Current __current) throws ServerError {
        try {
            int size = RomioPixelBuffer.safeLongToInteger((Long)this.reader.getStackSize());
            byte[] stack = new byte[size];
            this.reader.getStack(Integer.valueOf(c), Integer.valueOf(t), stack);
            this.reader.swapIfRequired(stack);
            __cb.ice_response(stack);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getTimepointOffset_async(AMD_RawPixelsStore_getTimepointOffset __cb, int t, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getTimepointOffset(Integer.valueOf(t)));
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getTimepointSize_async(AMD_RawPixelsStore_getTimepointSize __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getTimepointSize());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getTimepoint_async(AMD_RawPixelsStore_getTimepoint __cb, int t, Current __current) throws ServerError {
        try {
            int size = RomioPixelBuffer.safeLongToInteger((Long)this.reader.getTimepointSize());
            byte[] timepoint = new byte[size];
            this.reader.getTimepoint(Integer.valueOf(t), timepoint);
            this.reader.swapIfRequired(timepoint);
            __cb.ice_response(timepoint);
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getTotalSize_async(AMD_RawPixelsStore_getTotalSize __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.getTotalSize());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void isFloat_async(AMD_RawPixelsStore_isFloat __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.isFloat());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void isSigned_async(AMD_RawPixelsStore_isSigned __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.reader.isSigned());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void prepare_async(AMD_RawPixelsStore_prepare __cb, List<Long> pixelsIds, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void save_async(AMD_RawPixelsStore_save __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void setPixelsId_async(AMD_RawPixelsStore_setPixelsId __cb, long pixelsId, boolean bypassOriginalFile, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void getPixelsId_async(AMD_RawPixelsStore_getPixelsId __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getPixelsPath_async(AMD_RawPixelsStore_getPixelsPath __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void setPlane_async(AMD_RawPixelsStore_setPlane __cb, byte[] buf, int z, int c, int t, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setRegion_async(AMD_RawPixelsStore_setRegion __cb, int size, long offset, byte[] buffer, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setRow_async(AMD_RawPixelsStore_setRow __cb, byte[] buf, int y, int z, int c, int t, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setStack_async(AMD_RawPixelsStore_setStack __cb, byte[] buf, int z, int c, int t, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void setTimepoint_async(AMD_RawPixelsStore_setTimepoint __cb, byte[] buf, int t, Current __current) throws ServerError {
        throw new UnsupportedOperationException("Cannot write to repository");
    }

    @Override
    public void getHistogram_async(AMD_RawPixelsStore_getHistogram __cb, int[] channels, int binCount, boolean globalRange, PlaneDef plane, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void findMinMax_async(AMD_RawPixelsStore_findMinMax __cb, int[] channels, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void activate_async(AMD_StatefulServiceInterface_activate __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void close_async(AMD_StatefulServiceInterface_close __cb, Current __current) throws ServerError {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    @Override
    public void getCurrentEventContext_async(AMD_StatefulServiceInterface_getCurrentEventContext __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void passivate_async(AMD_StatefulServiceInterface_passivate __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getResolutionLevels_async(AMD_PyramidService_getResolutionLevels __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getResolutionDescriptions_async(AMD_PyramidService_getResolutionDescriptions __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getTileSize_async(AMD_PyramidService_getTileSize __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void requiresPixelsPyramid_async(AMD_PyramidService_requiresPixelsPyramid __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void setResolutionLevel_async(AMD_PyramidService_setResolutionLevel __cb, int resolutionLevel, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getResolutionLevel_async(AMD_PyramidService_getResolutionLevel __cb, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void getTile_async(AMD_RawPixelsStore_getTile __cb, int z, int c, int t, int x, int y, int w, int h, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void setTile_async(AMD_RawPixelsStore_setTile __cb, byte[] buf, int z, int c, int t, int x, int y, int w, int h, Current __current) throws ServerError {
        throw new UnsupportedOperationException("NYI");
    }
}

