/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.Object;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.formats.FormatReader;
import ome.api.IAdmin;
import ome.api.IUpdate;
import ome.conditions.ApiUsageException;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.model.IObject;
import ome.model.meta.Experimenter;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.FileMaker;
import ome.services.blitz.repo.ManagedImportLocationI;
import ome.services.blitz.repo.ManagedImportProcessI;
import ome.services.blitz.repo.ProcessContainer;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.blitz.repo.RepositoryDao;
import ome.services.blitz.repo.path.ClientFilePathTransformer;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.repo.path.MakeNextDirectory;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import ome.system.EventContext;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import omero.ResourceError;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.ImportLocation;
import omero.grid.ImportProcessPrx;
import omero.grid.ImportSettings;
import omero.grid._ManagedRepositoryOperations;
import omero.grid._ManagedRepositoryTie;
import omero.model.ChecksumAlgorithm;
import omero.model.Fileset;
import omero.model.FilesetEntry;
import omero.model.FilesetI;
import omero.model.FilesetJobLink;
import omero.model.IndexingJobI;
import omero.model.Job;
import omero.model.MetadataImportJobI;
import omero.model.NamedValue;
import omero.model.OriginalFile;
import omero.model.PixelDataJobI;
import omero.model.ThumbnailGenerationJobI;
import omero.model.UploadJob;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ManagedRepositoryI
extends PublicRepositoryI
implements _ManagedRepositoryOperations {
    private static final Logger log = LoggerFactory.getLogger(ManagedRepositoryI.class);
    private static final int parentDirsToRetain = 3;
    private static final ClientFilePathTransformer nopClientTransformer = new ClientFilePathTransformer(new Function<String, String>(){

        public String apply(String from) {
            return from;
        }
    });
    private static final DateFormatSymbols DATE_FORMAT = new DateFormatSymbols();
    private static final String ALL_CHECKSUM_ALGORITHMS = Joiner.on((char)',').join((Iterable)Collections2.transform(ChecksumAlgorithmMapper.getAllChecksumAlgorithms(), ChecksumAlgorithmMapper.CHECKSUM_ALGORITHM_NAMER));
    private static final Pattern TEMPLATE_TERM = Pattern.compile("%([a-zA-Z]+)(:([^%/]+))?%");
    protected FsFile templateRoot;
    private final FsFile templateUser;
    private final ProcessContainer processes;
    private final String rootSessionUuid;
    private final long userGroupId;
    private final Set<String> managedRepoUuids;

    public ManagedRepositoryI(String template, RepositoryDao dao) throws Exception {
        this(template, dao, new ProcessContainer(), (ChecksumProviderFactory)new ChecksumProviderFactoryImpl(), ALL_CHECKSUM_ALGORITHMS, FilePathRestrictionInstance.UNIX_REQUIRED.name, null, new Roles(), new HashSet<String>());
    }

    public ManagedRepositoryI(String template, RepositoryDao dao, ProcessContainer processes, ChecksumProviderFactory checksumProviderFactory, String checksumAlgorithmSupported, String pathRules, String rootSessionUuid, Roles roles, Set<String> managedRepoUuids) throws ServerError {
        super(dao, checksumProviderFactory, checksumAlgorithmSupported, pathRules);
        this.managedRepoUuids = managedRepoUuids;
        int splitPoint = template.lastIndexOf("//");
        if (splitPoint < 0) {
            splitPoint = 0;
        }
        this.templateRoot = new FsFile(template.substring(0, splitPoint));
        this.templateUser = new FsFile(template.substring(splitPoint));
        if (FsFile.emptyPath.equals(this.templateUser)) {
            throw new omero.ApiUsageException(null, null, "no user-owned directories in managed repository template path");
        }
        this.processes = processes;
        this.rootSessionUuid = rootSessionUuid;
        this.userGroupId = roles.getUserGroupId();
        log.info("Repository template: " + template);
    }

    @Override
    public Object tie() {
        return new _ManagedRepositoryTie(this);
    }

    @Override
    public void initialize(FileMaker fileMaker, Long id, String repoUuid) throws ValidationException {
        super.initialize(fileMaker, id, repoUuid);
        this.managedRepoUuids.add(repoUuid);
    }

    public ImportProcessPrx uploadFileset(Fileset fs, ImportSettings settings, Current __current) throws ServerError {
        ImportLocation location = this.internalImport(fs, settings, __current);
        return this.createUploadProcess(fs, location, settings, __current, true);
    }

    @Override
    public ImportProcessPrx importFileset(Fileset fs, ImportSettings settings, Current __current) throws ServerError {
        ImportLocation location = this.internalImport(fs, settings, __current);
        return this.createImportProcess(fs, location, settings, __current);
    }

    private ImportLocation internalImport(Fileset fs, ImportSettings settings, Current __current) throws ServerError {
        if (fs == null || fs.sizeOfUsedFiles() < 1) {
            throw new omero.ApiUsageException(null, null, "No paths provided");
        }
        if (settings == null) {
            settings = new ImportSettings();
        }
        if (settings.checksumAlgorithm == null) {
            throw new omero.ApiUsageException(null, null, "must specify checksum algorithm");
        }
        ArrayList<FsFile> paths = new ArrayList<FsFile>();
        for (FilesetEntry entry : fs.copyUsedFiles()) {
            paths.add(new FsFile(entry.getClientPath().getValue()));
        }
        ImmutableList sortedPaths = Ordering.usingToString().immutableSortedCopy(paths);
        FsFile relPath = this.createTemplatePath(sortedPaths, __current);
        fs.setTemplatePrefix(rtypes.rstring(relPath.toString() + FsFile.separatorChar));
        Class<? extends FormatReader> readerClass = this.getReaderClass(fs, __current);
        FsFile basePath = this.commonRoot(paths);
        return this.suggestImportPaths(relPath, basePath, paths, readerClass, settings.checksumAlgorithm, __current);
    }

    @Override
    public ImportProcessPrx importPaths(List<String> paths, Current __current) throws ServerError {
        if (paths == null || paths.size() < 1) {
            throw new omero.ApiUsageException(null, null, "No paths provided");
        }
        ImportContainer container = new ImportContainer(null, null, null, "Unknown", paths.toArray(new String[0]), false);
        ImportSettings settings = new ImportSettings();
        FilesetI fs = new FilesetI();
        try {
            container.fillData(new ImportConfig(), settings, fs, nopClientTransformer);
            settings.checksumAlgorithm = (ChecksumAlgorithm)this.checksumAlgorithms.get(0);
        }
        catch (IOException e) {
            throw new IceMapper().handleServerError(e, this.context);
        }
        return this.importFileset(fs, settings, __current);
    }

    @Override
    public List<ImportProcessPrx> listImports(Current __current) throws ServerError {
        ArrayList<Long> filesetIds = new ArrayList<Long>();
        ArrayList<ImportProcessPrx> proxies = new ArrayList<ImportProcessPrx>();
        omero.sys.EventContext ec = this.repositoryDao.getEventContext(__current);
        List<ProcessContainer.Process> ps = this.processes.listProcesses(ec.memberOfGroups);
        for (ProcessContainer.Process p : ps) {
            filesetIds.add(p.getFileset().getId().getValue());
        }
        List<Fileset> filesets = this.repositoryDao.loadFilesets(filesetIds, __current);
        for (Fileset fs : filesets) {
            if (fs.getDetails().getPermissions().canEdit()) continue;
            filesetIds.remove(fs.getId().getValue());
        }
        for (ProcessContainer.Process p : ps) {
            if (!filesetIds.contains(p.getFileset().getId())) continue;
            proxies.add(p.getProxy());
        }
        return proxies;
    }

    @Override
    public List<ChecksumAlgorithm> listChecksumAlgorithms(Current __current) {
        return this.checksumAlgorithms;
    }

    @Override
    public ChecksumAlgorithm suggestChecksumAlgorithm(List<ChecksumAlgorithm> supported, Current __current) {
        HashSet supportedNames = new HashSet(Lists.transform(supported, ChecksumAlgorithmMapper.CHECKSUM_ALGORITHM_NAMER));
        for (ChecksumAlgorithm configured : this.listChecksumAlgorithms(__current)) {
            if (!supportedNames.contains(ChecksumAlgorithmMapper.CHECKSUM_ALGORITHM_NAMER.apply((java.lang.Object)configured))) continue;
            return configured;
        }
        return null;
    }

    @Override
    public List<Long> verifyChecksums(List<Long> ids, Current __current) throws ServerError {
        Current allGroupsCurrent = this.makeAdjustedCurrent(__current);
        allGroupsCurrent.ctx = new HashMap(__current.ctx);
        allGroupsCurrent.ctx.put("omero.group", "-1");
        ArrayList<Long> mismatchFiles = new ArrayList<Long>();
        for (long id : this.repositoryDao.filterFilesByRepository(this.getRepoUuid(), ids, allGroupsCurrent)) {
            ome.model.core.OriginalFile file = this.repositoryDao.getOriginalFileWithHasher(id, allGroupsCurrent);
            FsFile fsPath = new FsFile(file.getPath() + file.getName());
            String osPath = this.serverPaths.getServerFileFromFsFile(fsPath).getAbsolutePath();
            ome.model.enums.ChecksumAlgorithm hasher = file.getHasher();
            String hash = file.getHash();
            if (hasher == null || hash == null) continue;
            ChecksumProvider fromProvider = this.checksumProviderFactory.getProvider(ChecksumAlgorithmMapper.getChecksumType(hasher));
            fromProvider.putFile(osPath);
            if (fromProvider.checksumAsString().equalsIgnoreCase(hash)) continue;
            mismatchFiles.add(id);
        }
        return mismatchFiles;
    }

    @Override
    public List<Long> setChecksumAlgorithm(ChecksumAlgorithm toHasherWrapped, List<Long> ids, Current __current) throws ServerError {
        Current adjustedGroupCurrent = this.makeAdjustedCurrent(__current);
        adjustedGroupCurrent.ctx = new HashMap(__current.ctx);
        adjustedGroupCurrent.ctx.put("omero.group", "-1");
        String toHasherName = toHasherWrapped.getValue().getValue();
        ome.model.enums.ChecksumAlgorithm toHasher = this.repositoryDao.getChecksumAlgorithm(toHasherName, adjustedGroupCurrent);
        ChecksumType toType = ChecksumAlgorithmMapper.getChecksumType(toHasher);
        ArrayList<Long> adjustedFiles = new ArrayList<Long>();
        for (long id : this.repositoryDao.filterFilesByRepository(this.getRepoUuid(), ids, adjustedGroupCurrent)) {
            ome.model.core.OriginalFile file = this.repositoryDao.getOriginalFileWithHasher(id, adjustedGroupCurrent);
            FsFile fsPath = new FsFile(file.getPath() + file.getName());
            String osPath = this.serverPaths.getServerFileFromFsFile(fsPath).getAbsolutePath();
            ome.model.enums.ChecksumAlgorithm fromHasher = file.getHasher();
            String fromHash = file.getHash();
            ChecksumProvider fromProvider = null;
            if (fromHasher != null && fromHash != null) {
                if (toHasherName.equals(fromHasher.getValue())) continue;
                fromProvider = this.checksumProviderFactory.getProvider(ChecksumAlgorithmMapper.getChecksumType(fromHasher));
            }
            ChecksumProvider toProvider = this.checksumProviderFactory.getProvider(toType);
            toProvider.putFile(osPath);
            String toHash = toProvider.checksumAsString();
            if (fromProvider != null) {
                fromProvider.putFile(osPath);
                if (!fromProvider.checksumAsString().equals(fromHash)) {
                    throw new ServerError(null, null, "hash mismatch on file ID " + id);
                }
            }
            file.setHasher(toHasher);
            file.setHash(toHash);
            String fileGroup = Long.toString(file.getDetails().getGroup().getId());
            adjustedGroupCurrent.ctx.put("omero.group", fileGroup);
            this.repositoryDao.saveObject((IObject)file, adjustedGroupCurrent);
            adjustedGroupCurrent.ctx.put("omero.group", "-1");
            adjustedFiles.add(id);
        }
        return adjustedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportProcessPrx createImportProcess(Fileset fs, ImportLocation location, ImportSettings settings, Current __current) throws ServerError {
        Slf4JStopWatch sw = new Slf4JStopWatch();
        ImportConfig config = new ImportConfig();
        ArrayList<NamedValue> serverVersionInfo = new ArrayList<NamedValue>();
        config.fillVersionInfo(serverVersionInfo);
        if (fs.sizeOfJobLinks() != 1) {
            throw new ValidationException(null, null, "Found more than one job link. Link only updateJob on creation!");
        }
        FilesetJobLink jobLink = fs.getFilesetJobLink(0);
        Job job = jobLink.getChild();
        if (job == null) {
            throw new ValidationException(null, null, "Found null-UploadJob on creation");
        }
        if (!(job instanceof UploadJob)) {
            throw new ValidationException(null, null, "Found non-UploadJob on creation: " + job.getClass().getName());
        }
        MetadataImportJobI metadata = new MetadataImportJobI();
        metadata.setVersionInfo(serverVersionInfo);
        fs.linkJob(metadata);
        fs.linkJob(new PixelDataJobI());
        if (settings.doThumbnails != null && settings.doThumbnails.getValue()) {
            ThumbnailGenerationJobI thumbnail = new ThumbnailGenerationJobI();
            fs.linkJob(thumbnail);
        }
        fs.linkJob(new IndexingJobI());
        if (location instanceof ManagedImportLocationI) {
            CheckedPath logFile = ((ManagedImportLocationI)location).getLogFile();
            ome.model.core.OriginalFile of = logFile.asOriginalFile("application/omero-log-file");
            of = this.persistLogFile(of, __current);
            job.linkOriginalFile((OriginalFile)new IceMapper().map((Filterable)of));
            try {
                MDC.put((String)"fileset", (String)logFile.getFullFsPath());
                sw.stop("omero.import.process.init");
            }
            finally {
                MDC.clear();
            }
        }
        return this.createUploadProcess(fs, location, settings, __current, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportProcessPrx createUploadProcess(Fileset fs, ImportLocation location, ImportSettings settings, Current __current, boolean uploadOnly) throws ServerError {
        Slf4JStopWatch sw = new Slf4JStopWatch();
        MDC.put((String)"fileset", (String)((ManagedImportLocationI)location).getLogFile().getFullFsPath());
        try {
            int size = fs.sizeOfUsedFiles();
            ArrayList<CheckedPath> checked = new ArrayList<CheckedPath>();
            for (int i = 0; i < size; ++i) {
                String path = location.sharedPath + FsFile.separatorChar + location.usedFiles.get(i);
                checked.add(this.checkPath(path, settings.checksumAlgorithm, __current));
            }
            Fileset managedFs = this.repositoryDao.saveFileset(this.getRepoUuid(), fs, settings.checksumAlgorithm, checked, __current);
            ManagedImportProcessI proc = new ManagedImportProcessI(this, managedFs, location, settings, __current, this.rootSessionUuid);
            this.processes.addProcess(proc);
            ImportProcessPrx importProcessPrx = proc.getProxy();
            return importProcessPrx;
        }
        finally {
            sw.stop("omero.import.process.create");
            MDC.clear();
        }
    }

    protected Class<? extends FormatReader> getReaderClass(Fileset fs, Current __current) {
        for (Job job : fs.linkedJobList()) {
            Class<?> potentialReaderClass;
            List versionInfo;
            if (!(job instanceof UploadJob) || (versionInfo = ((UploadJob)job).getVersionInfo(__current)) == null) continue;
            String readerName = null;
            for (NamedValue nv : versionInfo) {
                if (nv == null || !ImportConfig.VersionInfo.BIO_FORMATS_READER.key.equals(nv.name)) continue;
                readerName = nv.value;
                break;
            }
            if (readerName == null) continue;
            try {
                potentialReaderClass = Class.forName(readerName);
            }
            catch (NullPointerException npe) {
                log.debug("No info provided for reader class");
                continue;
            }
            catch (Exception e) {
                log.warn("Error getting reader class", (Throwable)e);
                continue;
            }
            if (!FormatReader.class.isAssignableFrom(potentialReaderClass)) continue;
            return potentialReaderClass;
        }
        return null;
    }

    protected FsFile commonRoot(List<FsFile> paths) {
        ArrayList<String> commonRoot = new ArrayList<String>();
        int index = 0;
        boolean isCommon = false;
        while (true) {
            String component = null;
            for (FsFile path : paths) {
                List<String> components = path.getComponents();
                if (components.size() <= index + 1) {
                    isCommon = false;
                } else if (component == null) {
                    component = components.get(index);
                    isCommon = true;
                } else {
                    isCommon = component.equals(components.get(index));
                }
                if (isCommon) continue;
                break;
            }
            if (!isCommon) break;
            commonRoot.add(paths.get(0).getComponents().get(index++));
        }
        return new FsFile(commonRoot);
    }

    private FsFile expandTemplateRootOwnedPath(omero.sys.EventContext ctx, Current current) throws ServerError {
        return new TemplateDirectoryCreator(FsFile.emptyPath, this.templateRoot, ctx, null, false, current).create();
    }

    protected FsFile expandTemplateRootOwnedPath(omero.sys.EventContext ctx, ServiceFactory sf) throws ServerError {
        return new TemplateDirectoryCreator(FsFile.emptyPath, this.templateRoot, ctx, null, false, sf).create();
    }

    private FsFile expandAndCreateTemplateUserOwnedPath(omero.sys.EventContext ctx, FsFile rootBase, java.lang.Object consistentData, Current current) throws ServerError {
        return new TemplateDirectoryCreator(rootBase, this.templateUser, ctx, consistentData, true, current).create();
    }

    protected FsFile createTemplatePath(java.lang.Object consistentData, Current __current) throws ServerError {
        FsFile rootOwnedExpanded;
        omero.sys.EventContext ctx = this.repositoryDao.getEventContext(__current);
        if (FsFile.emptyPath.equals(this.templateRoot)) {
            rootOwnedExpanded = FsFile.emptyPath;
        } else {
            rootOwnedExpanded = this.expandTemplateRootOwnedPath(ctx, __current);
            Current rootCurr = this.sudo(__current, this.rootSessionUuid);
            rootCurr.ctx.put("omero.group", Long.toString(this.userGroupId));
            this.makeDir(rootOwnedExpanded.toString(), true, rootCurr);
        }
        FsFile wholeExpanded = this.expandAndCreateTemplateUserOwnedPath(ctx, rootOwnedExpanded, consistentData, __current);
        if (wholeExpanded.equals(rootOwnedExpanded)) {
            throw new omero.ApiUsageException(null, null, "no user-owned directories in expanded form of managed repository template path");
        }
        return wholeExpanded;
    }

    protected Paths trimPaths(FsFile basePath, List<FsFile> fullPaths, Class<? extends FormatReader> readerClass) {
        int baseDirsToTrim;
        Integer commonParentDirsToRetain = null;
        String[] localStylePaths = new String[fullPaths.size()];
        int index = 0;
        for (FsFile fsFile : fullPaths) {
            localStylePaths[index++] = this.serverPaths.getServerFileFromFsFile(fsFile).getAbsolutePath();
        }
        try {
            commonParentDirsToRetain = readerClass.newInstance().getRequiredDirectories(localStylePaths);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<String> basePathComponents = basePath.getComponents();
        if (commonParentDirsToRetain == null) {
            int smallestPathLength;
            if (fullPaths.isEmpty()) {
                smallestPathLength = 1;
            } else {
                smallestPathLength = Integer.MAX_VALUE;
                for (FsFile path : fullPaths) {
                    int pathLength = path.getComponents().size();
                    if (smallestPathLength <= pathLength) continue;
                    smallestPathLength = pathLength;
                }
            }
            baseDirsToTrim = smallestPathLength - 3 - 1;
        } else {
            baseDirsToTrim = basePathComponents.size() - commonParentDirsToRetain;
        }
        if (baseDirsToTrim < 0) {
            return new Paths(basePath, fullPaths);
        }
        basePath = new FsFile(basePathComponents.subList(baseDirsToTrim, basePathComponents.size()));
        ArrayList<FsFile> trimmedPaths = new ArrayList<FsFile>(fullPaths.size());
        for (FsFile path : fullPaths) {
            List<String> pathComponents = path.getComponents();
            trimmedPaths.add(new FsFile(pathComponents.subList(baseDirsToTrim, pathComponents.size())));
        }
        return new Paths(basePath, trimmedPaths);
    }

    protected ImportLocation suggestImportPaths(FsFile relPath, FsFile basePath, List<FsFile> paths, Class<? extends FormatReader> reader, ChecksumAlgorithm checksumAlgorithm, Current __current) throws ServerError {
        Paths trimmedPaths = this.trimPaths(basePath, paths, reader);
        basePath = trimmedPaths.basePath;
        paths = trimmedPaths.fullPaths;
        Function<String, String> sanitizer = this.serverPaths.getPathSanitizer();
        relPath = relPath.transform(sanitizer);
        basePath = basePath.transform(sanitizer);
        int index = paths.size();
        while (--index >= 0) {
            paths.set(index, paths.get(index).transform(sanitizer));
        }
        ManagedImportLocationI data = new ManagedImportLocationI();
        data.logFile = this.checkPath(relPath.toString() + ".log", checksumAlgorithm, __current);
        FsFile newBase = FsFile.concatenate(relPath, basePath);
        data.sharedPath = newBase.toString();
        data.usedFiles = new ArrayList(paths.size());
        data.checkedPaths = new ArrayList<CheckedPath>(paths.size());
        for (FsFile path : paths) {
            String relativeToEnd = path.getPathFrom(basePath).toString();
            data.usedFiles.add(relativeToEnd);
            String fullRepoPath = data.sharedPath + FsFile.separatorChar + relativeToEnd;
            data.checkedPaths.add(new CheckedPath(this.serverPaths, fullRepoPath, this.checksumProviderFactory, checksumAlgorithm));
        }
        ArrayList<CheckedPath> dirs = new ArrayList<CheckedPath>();
        HashSet<String> seen = new HashSet<String>();
        dirs.add(this.checkPath(data.sharedPath, checksumAlgorithm, __current));
        for (CheckedPath checked : data.checkedPaths) {
            if (seen.contains(checked.getRelativePath())) continue;
            dirs.add(checked.parent());
            seen.add(checked.getRelativePath());
        }
        this.repositoryDao.makeDirs(this, dirs, true, __current);
        return data;
    }

    private static boolean isConsistentPrefixes(Iterable<?> x, Iterable<?> y) {
        Iterator<?> xIterator = x.iterator();
        Iterator<?> yIterator = y.iterator();
        while (xIterator.hasNext() && yIterator.hasNext()) {
            if (xIterator.next().equals(yIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void makeCheckedDirs(LinkedList<CheckedPath> paths, boolean parents, Session s, ServiceFactory sf, SqlAction sql, EventContext effectiveEventContext) throws ServerError {
        IAdmin adminService = sf.getAdminService();
        omero.sys.EventContext ec = IceMapper.convert(effectiveEventContext);
        FsFile rootOwnedPath = this.expandTemplateRootOwnedPath(ec, sf);
        ArrayList<CheckedPath> pathsToFix = new ArrayList<CheckedPath>();
        EventContext currentEventContext = adminService.getEventContext();
        long rootId = adminService.getSecurityRoles().getRootId();
        ImmutableList pathsForRoot = currentEventContext.getCurrentUserId() == rootId ? ImmutableList.copyOf(paths) : ImmutableList.of();
        for (int i = 0; i < paths.size(); ++i) {
            CheckedPath checked = paths.get(i);
            if (checked.isRoot) {
                throw new ResourceError(null, null, "Cannot re-create root!");
            }
            if (!ManagedRepositoryI.isConsistentPrefixes(rootOwnedPath.getComponents(), checked.fsFile.getComponents())) {
                if (currentEventContext.isCurrentUserAdmin()) {
                    pathsForRoot = ImmutableList.copyOf(paths);
                } else {
                    throw new ValidationException(null, null, "cannot create directory \"" + checked.fsFile + "\" with template path's root-owned \"" + rootOwnedPath + "\"");
                }
            }
            pathsToFix.add(checked);
        }
        super.makeCheckedDirs(paths, parents, s, sf, sql, effectiveEventContext);
        if (!pathsForRoot.isEmpty()) {
            Experimenter rootUser = (Experimenter)sf.getQueryService().find(Experimenter.class, rootId);
            IUpdate updateService = sf.getUpdateService();
            for (CheckedPath pathForRoot : pathsForRoot) {
                ome.model.core.OriginalFile directory = this.repositoryDao.findRepoFile(sf, sql, this.getRepoUuid(), pathForRoot, null);
                if (directory.getDetails().getOwner().getId() == rootId) continue;
                directory.getDetails().setOwner(rootUser);
                updateService.saveObject((IObject)directory);
            }
        }
        this.repositoryDao.createOrFixUserDir(this.getRepoUuid(), pathsToFix, s, sf, sql);
    }

    private static class Paths {
        final FsFile basePath;
        final List<FsFile> fullPaths;

        Paths(FsFile basePath, List<FsFile> fullPaths) {
            this.basePath = basePath;
            this.fullPaths = fullPaths;
        }
    }

    private class TemplateDirectoryCreator {
        private final Calendar now = Calendar.getInstance();
        private final omero.sys.EventContext ctx;
        private final java.lang.Object consistentData;
        private final boolean createDirectories;
        private final Current current;
        private final ServiceFactory sf;
        private final Deque<String> remaining;
        private final List<String> done;

        TemplateDirectoryCreator(FsFile base, FsFile todo, omero.sys.EventContext ctx, java.lang.Object consistentData, boolean createDirectories, Current current) {
            this.ctx = ctx;
            this.consistentData = consistentData;
            this.createDirectories = createDirectories;
            this.current = current;
            this.sf = null;
            this.remaining = new ArrayDeque<String>(todo.getComponents());
            this.done = new ArrayList<String>(base.getComponents());
        }

        TemplateDirectoryCreator(FsFile base, FsFile todo, omero.sys.EventContext ctx, java.lang.Object consistentData, boolean createDirectories, ServiceFactory sf) {
            if (createDirectories) {
                throw new ApiUsageException("may not create directories with only a service factory");
            }
            this.ctx = ctx;
            this.consistentData = consistentData;
            this.createDirectories = createDirectories;
            this.current = null;
            this.sf = sf;
            this.remaining = new ArrayDeque<String>(todo.getComponents());
            this.done = new ArrayList<String>(base.getComponents());
        }

        private String getFullPathWith(List<String> path) {
            StringBuffer sb = new StringBuffer();
            for (String component : Iterables.concat(this.done, path)) {
                sb.append(FsFile.separatorChar);
                sb.append(component);
            }
            return sb.toString();
        }

        public String expandUser(String prefix, String suffix) {
            return prefix + (String)ManagedRepositoryI.this.serverPaths.getPathSanitizer().apply((java.lang.Object)this.ctx.userName) + suffix;
        }

        public String expandUserId(String prefix, String suffix) {
            return prefix + this.ctx.userId + suffix;
        }

        public String expandGroup(String prefix, String suffix) {
            return prefix + (String)ManagedRepositoryI.this.serverPaths.getPathSanitizer().apply((java.lang.Object)this.ctx.groupName) + suffix;
        }

        public String expandGroupId(String prefix, String suffix) {
            return prefix + this.ctx.groupId + suffix;
        }

        public String expandYear(String prefix, String suffix) {
            return prefix + this.now.get(1) + suffix;
        }

        public String expandMonth(String prefix, String suffix) {
            return prefix + String.format("%02d", this.now.get(2) + 1) + suffix;
        }

        public String expandMonthname(String prefix, String suffix) {
            return prefix + DATE_FORMAT.getMonths()[this.now.get(2)] + suffix;
        }

        public String expandDay(String prefix, String suffix) {
            return prefix + String.format("%02d", this.now.get(5)) + suffix;
        }

        public void expandAndCreateTime(final String prefix, final String suffix) throws ServerError {
            MakeNextDirectory directoryMaker = new MakeNextDirectory(){

                @Override
                public List<String> getPathFor(long index) {
                    int hour = TemplateDirectoryCreator.this.now.get(11);
                    int minute = TemplateDirectoryCreator.this.now.get(12);
                    int second = TemplateDirectoryCreator.this.now.get(13);
                    long millisecond = (long)TemplateDirectoryCreator.this.now.get(14) + index;
                    String time = String.format("%s%02d-%02d-%02d.%03d%s", prefix, hour, minute, second, millisecond, suffix);
                    return Collections.singletonList(time);
                }

                @Override
                public boolean isAcceptable(List<String> path) throws ServerError {
                    return !ManagedRepositoryI.this.checkPath(TemplateDirectoryCreator.this.getFullPathWith(path), null, TemplateDirectoryCreator.this.current).exists();
                }

                @Override
                public void usePath(List<String> path) throws ServerError {
                    ManagedRepositoryI.this.makeDir(TemplateDirectoryCreator.this.getFullPathWith(path), false, TemplateDirectoryCreator.this.current);
                }
            };
            this.done.addAll(directoryMaker.useFirstAcceptable());
        }

        public String expandSession(String prefix, String suffix) {
            return prefix + this.ctx.sessionUuid + suffix;
        }

        public String expandSessionId(String prefix, String suffix) {
            return prefix + this.ctx.sessionId + suffix;
        }

        public String expandPerms(String prefix, String suffix) {
            return prefix + this.ctx.groupPermissions + suffix;
        }

        public String expandInstitution(String prefix, String suffix) {
            String institution = this.current != null ? ManagedRepositoryI.this.repositoryDao.getUserInstitution(this.ctx.userId, this.current) : ManagedRepositoryI.this.repositoryDao.getUserInstitution(this.ctx.userId, this.sf);
            if (StringUtils.isBlank((String)institution)) {
                return null;
            }
            return prefix + (String)ManagedRepositoryI.this.serverPaths.getPathSanitizer().apply((java.lang.Object)institution) + suffix;
        }

        public String expandInstitution(String prefix, String suffix, String defaultForNone) {
            String institution = this.current != null ? ManagedRepositoryI.this.repositoryDao.getUserInstitution(this.ctx.userId, this.current) : ManagedRepositoryI.this.repositoryDao.getUserInstitution(this.ctx.userId, this.sf);
            if (StringUtils.isBlank((String)institution)) {
                institution = defaultForNone;
            }
            return prefix + (String)ManagedRepositoryI.this.serverPaths.getPathSanitizer().apply((java.lang.Object)institution) + suffix;
        }

        public String expandHash(String prefix, String suffix) throws ServerError {
            return this.expandHash(prefix, suffix, "8");
        }

        public String expandHash(String prefix, String suffix, String parameters) throws ServerError {
            if (this.consistentData == null) {
                throw new ServerError(null, null, "%hash% is prohibited in this part of the repository template path");
            }
            String hash = Long.toHexString(0x200000000L + (long)this.consistentData.hashCode()).substring(1).toUpperCase();
            ArrayDeque<String> components = new ArrayDeque<String>();
            int currentPosition = 0;
            for (String digitCount : Splitter.on((char)',').split((CharSequence)parameters)) {
                int length = Integer.parseInt(digitCount);
                if (length < 1 || length + currentPosition > hash.length()) {
                    throw new ServerError(null, null, "invalid parameters \"" + parameters + "\" for %hash% in the repository template path");
                }
                components.push(prefix + hash.substring(currentPosition, currentPosition + length) + suffix);
                currentPosition += length;
                prefix = "";
                suffix = "";
            }
            while (!components.isEmpty()) {
                this.remaining.push((String)components.pop());
            }
            return null;
        }

        public void expandAndCreateIncrement(String prefix, String suffix) throws ServerError {
            this.expandAndCreateIncrement(prefix, suffix, "0");
        }

        public void expandAndCreateIncrement(final String prefix, final String suffix, String paddingString) throws ServerError {
            final int padding = Integer.parseInt(paddingString);
            MakeNextDirectory directoryMaker = new MakeNextDirectory(){

                @Override
                public List<String> getPathFor(long index) {
                    return Collections.singletonList(prefix + Strings.padStart((String)Long.toString(index + 1L), (int)padding, (char)'0') + suffix);
                }

                @Override
                public boolean isAcceptable(List<String> path) throws ServerError {
                    return !ManagedRepositoryI.this.checkPath(TemplateDirectoryCreator.this.getFullPathWith(path), null, TemplateDirectoryCreator.this.current).exists();
                }

                @Override
                public void usePath(List<String> path) throws ServerError {
                    ManagedRepositoryI.this.makeDir(TemplateDirectoryCreator.this.getFullPathWith(path), false, TemplateDirectoryCreator.this.current);
                }
            };
            this.done.addAll(directoryMaker.useFirstAcceptable());
        }

        private List<String> getExtraSubdirectories(String prefix, String suffix, int digits, long count) {
            ArrayList<String> subdirectories = new ArrayList<String>();
            StringBuffer paddedCount = new StringBuffer();
            paddedCount.append(count);
            while (paddedCount.length() % digits != 0) {
                paddedCount.insert(0, '0');
            }
            int l = paddedCount.length();
            for (int c = 0; c < l; c += digits) {
                subdirectories.add(prefix + paddedCount.substring(c, c + digits) + suffix);
                prefix = "";
                suffix = "";
            }
            return subdirectories;
        }

        private int directoryContentsCount(String path) {
            File directory = ManagedRepositoryI.this.serverPaths.getServerFileFromFsFile(new FsFile(path));
            if (directory.exists()) {
                if (directory.isDirectory()) {
                    return directory.list().length;
                }
            } else {
                File parent = directory.getParentFile();
                if (parent != null && parent.exists() && parent.isDirectory()) {
                    return 0;
                }
            }
            return Integer.MAX_VALUE;
        }

        public void expandAndCreateSubdirs(String prefix, String suffix) throws ServerError {
            this.expandAndCreateSubdirs(prefix, suffix, "3");
        }

        public void expandAndCreateSubdirs(final String prefix, final String suffix, String digitsString) throws ServerError {
            final int digits = Integer.parseInt(digitsString);
            if (digits < 1) {
                throw new ServerError(null, null, "invalid parameter \"" + digitsString + "\" for %subdirs% in the repository template path");
            }
            final int limit = IntMath.checkedPow((int)10, (int)digits);
            if (this.directoryContentsCount(this.getFullPathWith(Collections.emptyList())) < limit) {
                return;
            }
            MakeNextDirectory directoryMaker = new MakeNextDirectory(){

                @Override
                public List<String> getPathFor(long index) {
                    return TemplateDirectoryCreator.this.getExtraSubdirectories(prefix, suffix, digits, index);
                }

                @Override
                public boolean isAcceptable(List<String> path) throws ServerError {
                    return TemplateDirectoryCreator.this.directoryContentsCount(TemplateDirectoryCreator.this.getFullPathWith(path)) < limit;
                }

                @Override
                public void usePath(List<String> path) throws ServerError {
                    ManagedRepositoryI.this.makeDir(TemplateDirectoryCreator.this.getFullPathWith(path), true, TemplateDirectoryCreator.this.current);
                }
            };
            this.done.addAll(directoryMaker.useFirstAcceptable());
        }

        public String expandThread(String prefix, String suffix) {
            return prefix + (String)ManagedRepositoryI.this.serverPaths.getPathSanitizer().apply((java.lang.Object)Thread.currentThread().getName()) + suffix;
        }

        FsFile create() throws ServerError {
            while (!this.remaining.isEmpty()) {
                String pattern = this.remaining.pop();
                Matcher matcher = TEMPLATE_TERM.matcher(pattern);
                boolean isMatcherPristine = true;
                while (pattern != null) {
                    if (!matcher.find()) {
                        if (isMatcherPristine) {
                            this.done.add(pattern);
                            break;
                        }
                        throw new ServerError(null, null, "cannot expand template repository path component \"" + pattern + '\"');
                    }
                    isMatcherPristine = false;
                    String prefix = pattern.substring(0, matcher.start());
                    String suffix = pattern.substring(matcher.end());
                    String term = matcher.group(1);
                    String parameters = matcher.group(3);
                    String oldPattern = pattern;
                    boolean isTryCreateDirectory = this.createDirectories && !TEMPLATE_TERM.matcher(prefix).find() && !TEMPLATE_TERM.matcher(suffix).find();
                    try {
                        while (true) {
                            String methodName3;
                            Method expander;
                            String methodName2;
                            if (parameters == null) {
                                try {
                                    methodName2 = "expand" + StringUtils.capitalize((String)term);
                                    expander = this.getClass().getMethod(methodName2, String.class, String.class);
                                    pattern = (String)expander.invoke((java.lang.Object)this, prefix, suffix);
                                }
                                catch (NoSuchMethodException e1) {
                                    if (!isTryCreateDirectory) break;
                                    try {
                                        methodName3 = "expandAndCreate" + StringUtils.capitalize((String)term);
                                        expander = this.getClass().getMethod(methodName3, String.class, String.class);
                                        expander.invoke((java.lang.Object)this, prefix, suffix);
                                        pattern = null;
                                    }
                                    catch (NoSuchMethodException methodName3) {}
                                }
                                break;
                            }
                            try {
                                methodName2 = "expand" + StringUtils.capitalize((String)term);
                                expander = this.getClass().getMethod(methodName2, String.class, String.class, String.class);
                                pattern = (String)expander.invoke((java.lang.Object)this, prefix, suffix, parameters);
                            }
                            catch (NoSuchMethodException e1) {
                                if (isTryCreateDirectory) {
                                    try {
                                        methodName3 = "expandAndCreate" + StringUtils.capitalize((String)term);
                                        expander = this.getClass().getMethod(methodName3, String.class, String.class, String.class);
                                        expander.invoke((java.lang.Object)this, prefix, suffix, parameters);
                                        pattern = null;
                                        break;
                                    }
                                    catch (NoSuchMethodException methodName4) {
                                        // empty catch block
                                    }
                                }
                                log.warn("ignoring parameters \"" + parameters + "\" on \"" + matcher.group(0) + "\" in repository template path");
                                parameters = null;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ServerError) {
                            throw (ServerError)((java.lang.Object)cause);
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        String message = "unexpected exception in expanding \"" + pattern + '\"';
                        throw new ServerError(null, null, message, cause);
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "unexpected exception in expanding \"" + pattern + '\"';
                        throw new ServerError(null, null, message, e);
                    }
                    if (pattern == null || oldPattern.equals(pattern)) continue;
                    matcher = TEMPLATE_TERM.matcher(pattern);
                    isMatcherPristine = true;
                }
                if (pattern == null || !this.createDirectories) continue;
                ManagedRepositoryI.this.makeDir(new FsFile(this.done).toString(), !this.remaining.isEmpty(), this.current);
            }
            return new FsFile(this.done);
        }
    }
}

